#ifndef _HUTILITYGEOMETRYCREATION_H
#define _HUTILITYGEOMETRYCREATION_H

#include "HUtility.h"

class MVO_API HUtilityGeometryCreation
{
public:
    static bool	GeneratePointOnCircle(HPoint* point, HPoint &center, float radius, int axis, float angle, bool convert=true);
    static bool	GeneratePointsOnCircle (HPoint* points, HPoint & center,float radius,int axis, int numpoints, bool convert=true);
    static void	CreateSphere(const char *segment, HPoint center, float radius, int num_faces);
    static void	CreateSphere(HPoint center, float radius, int numsides, HPoint axis, HPoint ref);
    static void	CreateCone(HPoint center, float radius, float height, int numsides, HPoint axis, HPoint ref);
    static void	CreateCylinder(HPoint center, float radius, float height, int numsides, HPoint axis, HPoint ref);
    static void CreateCuboid( HPoint *max, HPoint *min);
    static void	SetupModellingMatrix(HVector axis, HVector ref, HVector side, HPoint pos);

private:
    static void GenerateCuboidPoints( HPoint	*max, HPoint *min, HPoint *points);
};

#endif


