//Algolia code

const isValidUrl = urlString => {
    try {
        return Boolean(new URL(urlString));
    }
    catch (e) {
        return false;
    }
}
function convertBranchName(branchName) {
    let lastIndex = branchName.lastIndexOf('/');
    if (lastIndex !== -1 && branchName.startsWith('release')) {
        let prefix = branchName.substring(0, lastIndex + 1);
        let suffix = branchName.substring(lastIndex + 1);
        return prefix + suffix.toUpperCase();
    } else {
        return branchName;
    }
}
function SelectSearch() {
    const {hostname} = window.location;

    if (hostname.includes("docs-test") || hostname.includes("docs") || force_algolia_search) {
        
            return true;
        
    } else{
        const node = document.querySelector('#entersearch');
        // Create a new div element
        const div = document.createElement('div');
        div.setAttribute('role', 'search');
        
        // Set the innerHTML of the div element to the provided HTML code
        div.innerHTML = `
        <form id="rtd-search-form" class="wy-form" action="${SearchFilePath}" method="get">
        <input type="text" name="q" placeholder="Search docs" aria-label="Search docs" />
        <input type="hidden" name="check_keywords" value="yes" />
        <input type="hidden" name="area" value="default" />
        </form>
        `;
        if (node) {
                    // Replace the #entersearch element with the new div element
            node.parentNode.replaceChild(div, entersearch);
            console.log("Algolia Search Disabled")
            return false;
        }
    }
}
function findRelativeUrl(url) {
    if (isValidUrl(url)) {
        let domain = new URL(url).hostname;
        const {pathname} = new URL(url);
        if (domain.split('.')[0] == "docs-test") {
            domain = "docs.techsoft3d.com"
        }
        return "https://" + domain + pathname;
    } else {
        if(LogoImagePath != ''){
            return LogoImagePath;
        }
        return url;
    }
}
function MakeUrl(link,highlight) {

    if (isValidUrl(link)) {
        //check that the url starts with http://docs-test.techsoft3d.com or http://docs.techsoft3d.com
        //if it does, then split the url into domain path and tag
        //if it doesn't, then just return the url
        let domain = new URL(link).hostname;
        const {pathname} = new URL(link);
        const tag = new URL(link).hash;

        if (domain.includes("docs-test") || domain.includes("docs")) {
            link = pathname + "?highlight=" + highlight + tag;
        }
        if(branchName !='' && window.location.hostname.includes("docs-test") ){
            branchName = convertBranchName(branchName);
            link = replaceLatest(branchName, link);
            
        }
        //if the current windows pathname contains master  then replace latest in the links with it
        if (window.location.pathname.includes("master")) {
            link = link.replace("latest", "master");
        }


        if(domain.includes("docs") && project == "HOOPS Visualize 3DF" && release.endsWith("LTS")){
            // Added code to handle all cases with different version numbers
            let pathArray = window.location.pathname.split("/");
            let versionIndex = pathArray.indexOf("3df") + 1;
            let versionNumber = pathArray[versionIndex];
            if (!isNaN(versionNumber) && versionNumber.length > 0) {
                link = link.replace("latest", versionNumber);
            }else if(branchName != ""){
                link = replaceLatest(branchName, link);
            }
        }

        
    }
    return link;

}
function replaceLatest(branchName, link) {
  
      return link.replace("latest", branchName);
   
  }
function hasOneTypeAndOneProduct(str) {
    const typeRegex = /type/g;
    const productRegex = /product/g;
    const typeMatches = str.match(typeRegex);
    const productMatches = str.match(productRegex);
    return typeMatches !== null && typeMatches.length === 1 && productMatches !== null && productMatches.length === 1;
}

function getIndexName() {
    let domain = new URL(window.location.href).hostname;
    let indexName = "UI-TEST"
    //Switch the index name based on the project and the domain
    if (domain.split('.')[0] == "docs") {
        indexName = "Production"
    } else {
        indexName = "Staging"
    }
    
    if (project == "HOOPS Visualize 3DF" && release.endsWith("LTS")){ indexName = "Staging-3DF-27.40"}
    return indexName;
}
window.addEventListener('DOMContentLoaded', e => {
    var isAlgoliaSearch = SelectSearch()
    if(isAlgoliaSearch){
    const { algoliasearch, instantsearch, aa } = window;
    const connectSearchBox = instantsearch.connectors.connectSearchBox;
    const instantSearchRouter = instantsearch.routers.history();
    const { autocomplete , getAlgoliaResults} = window['@algolia/autocomplete-js'];
    const { createLocalStorageRecentSearchesPlugin }  = window['@algolia/autocomplete-plugin-recent-searches'];
    const algoliaClient= algoliasearch('U6867AZUGF', '0f0418c7c80442fc575dcee4cf1ffb28');
    // Mount a virtual search box to manipulate InstantSearch's `query` UI
    // state parameter.
    const searchClient = {
      ...algoliaClient,
      search(requests) {
        
        if (requests.every(({ params , query }) => !params.query && !query)) {
          return Promise.resolve({
            
            results: requests.map(() => ({
              hits: [],
              nbHits: 0,
              nbPages: 0,
              page: 0,
              processingTimeMS: 0,
              hitsPerPage: 0,
              query: '',
              params: '',
            })),
          });
        }
    
        return algoliaClient.search(requests);
      },
    };
    const virtualSearchBox = connectSearchBox(() => {});
    aa('init', {
        appId: 'U6867AZUGF',
        apiKey: 'af938e74ffd98a433765d94f3e4479a0',
    })
    var modal = new tingle.modal({
        footer: true,
        stickyFooter: false,
        closeMethods: ['overlay', 'escape'],
        closeLabel: "Close",
        onOpen: function () {
            

            //const input = document.getElementsByClassName("ais-SearchBox-input")
            const autocompleteInput = document.getElementsByClassName("aa-Input")
            if (autocompleteInput.item(0) != null) {
                //input[0].focus();
                autocompleteInput[0].focus();
            }
        },
        onClose: function () {
        },
        beforeClose: function () {
            // here goes some logic
            // e.g. save content before closing the modal
            return true; // close the modal
        }
    });

    const element = document.getElementById('entersearch');
    const filter = element.getAttribute('class');
    const OpenSearchButton = element.querySelector('.Search-searchbar ');
    OpenSearchButton.addEventListener('click', e => {
        // Check if the event target is not inside the search form
        
            modal.open()
            e.preventDefault();
            // searchInput.classList.remove('is-focused');
        
    });
        // Keyboard shortcut listener
        window.addEventListener('keydown', (event) => {
            if (event.ctrlKey && event.key === 'k') {
                modal.open();
              event.preventDefault(); // Prevent the default browser behavior
            }
          });
          modal.setContent(`            
          <div id="searchbox" class=${filter} >

          </div>

          
          <div id="searchDiv"> 
                  <div id="current-refinements"></div>
                  
                  <div id="results_filters">
                      <div id="searchHelpers">
                      <div id="recentsearchPanel"></div>
                      <div id="labelLocation" style="margin-top: 0.5em; margin-bottom: 0.5em; display:inline-block;"><em id="header">Choose a Location :</em></div>
                      <div id="hierarchical-menu"></div>
                      </div>
                      <div style="max-width: 70%;padding:10px;padding-right:0;">
                          <div id="stats"></div>
                          <div id="Hits-per-page"></div>
                          <div id="hits"></div>
                      </div>
                  </div>
          </div>`);
          modal.setFooterContent(`<div id="GoButton">
          <img height="35" width="35" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAACXBIWXMAAAsTAAALEwEAmpwYAAACHElEQVR4nO2awUojQRCGv+SWnMzRePEtVlgWchRUfILkCfa8m5CAggjiM3jXJxCEXQ2eE9hnSG7LHlazhw0sW9LSgTFBmTjdM91JfVCHganq6n+6uppmQFEURVGK4BDoA38AcWQm1h1wQOCcOZz0a3ZKwF9egCnwBag7jG1ifbWxzRj7BEjfJmcS9UXbjnFLgExscpsex9i0YzwSIGJtVcZZGhUAXQFoCeAf3QPQTZCV6QKSk08uqADoCkBLgDDLJhe0BNASQEuAMMsm10vMqAQ4c3xheR+TAIceLzGjEKCfwyVm0AJMkpeYInIhIv/kJcessACSDFTA5Bdy8OiTSoAkR+RDkAIcLRFjB/gO/AI+Z83Bo09qAdJOfhu4Av4n4vzOmoNHn1QCpKn5DeAc+GtcKpWKdLvd9x6CFnLw6OMk0Efgp/Epl8vSbDZlNBo9L5t1EeCHeb/RaMhgMHixY2Y8PY485+1egOFw6EoAM/ldz3n7KYFWqyXj8ThrCbyHwgRY2ASr1ar0er21EiDZBi8dtMFoBZjxAfiW4SAUvQBFoALgeAXUiYctHyugTTx0fAgwtSLUA//yncR/gk4FkEjNmQCfgOvZKS9Qm5RKpZtarWaOzdoFcHwpWie+LvDgItjdG11gXuWin+e7gLmGy8zBG12g6AnPP893gT0ccRrABresneCYffv7+WxPCNEmdtk7+/KKoiiKwuryBMK14FjdaOMUAAAAAElFTkSuQmCC"></div> <em style="padding-right:15px">Go</em>
              <div class="SearchFooter-navigation-tip"><div class="SearchFooter-navigation-tip-icon"><div class="KeyboardNavUpDownIcon"><div class="SVGInline SVGInline--cleaned SVG Icon Icon--arrowUp SVG--color SVG--color--gray400 Box-root Flex-flex" style="padding-right: 0.05em;">
                <svg class="SVGInline-svg SVGInline--cleaned-svg SVG-svg Icon-svg Icon--arrowUp-svg SVG--color-svg SVG--color--gray400-svg" style="width: 10px;height: 10px;" height="16" viewBox="0 0 16 16" width="16" xmlns="http://www.w3.org/2000/svg">
                    <path d="M9 3.417V15a1 1 0 0 1-2 0V3.417L2.409 8.008A1 1 0 0 1 .993 6.593l6.3-6.3a1 1 0 0 1 1.414 0l6.3 6.3a1 1 0 0 1-1.416 1.415z" fill-rule="evenodd"></path></svg></div><div class="SVGInline SVGInline--cleaned SVG Icon Icon--arrowDown SVG--color SVG--color--gray400 Box-root Flex-flex">
                <svg class="SVGInline-svg SVGInline--cleaned-svg SVG-svg Icon-svg Icon--arrowDown-svg SVG--color-svg SVG--color--gray400-svg" style="width: 10px;height: 10px;" height="16" viewBox="0 0 16 16" width="16" xmlns="http://www.w3.org/2000/svg">
                    <path d="M9 12.583l4.591-4.591a1 1 0 0 1 1.416 1.415l-6.3 6.3a1 1 0 0 1-1.414 0l-6.3-6.3A1 1 0 0 1 2.41 7.992L7 12.583V1a1 1 0 1 1 2 0z" fill-rule="evenodd"></path></svg>
              </div></div></div>
              <div>Navigate</div></div>
              <img height="35" width="35" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAACXBIWXMAAAsTAAALEwEAmpwYAAACs0lEQVR4nO2ZPWgUURSFvywbTYKFiAqiRiu7lLYWNsZgYeNfoUZ2IxLEwt/GwkqtIlhpZWUTtEqMaKGFnYlgZZdsdIOigoIoarLrkydn4DE7uzsjOvMG5sCF3b139p2zb+7d++5AgQIF/hb9wBgwAywBK4BJ2Va09oy49CUVsQ94kwFx08VeAyNxRZwGmrrwOXAU2AqUSR9lrX0MmBWnBjAeZyeaCj4H9OAPeoDzDr+9nXIiuJ2sCF9xURwX2+XMSed28mknwrDc5sS12uJVZTDKCd9xXFyno5x1OW1y+Y5BcbWp0IJlObOoTknRK66WcwuCWp0XmHZ8CyEZwRQ7EkK7fqhCznbEqGRfD9nOf8c1PSHPusQcASaBh8CNiP+oQ8Ad+SeALT4KOaOYx8At4ANQA1bJf1b+eWAK+Aq8BTZmIeS7iLgW/OqPgM/687IYUj+3Tg3qF+CVXlvsAj4Bp7IQ8g64HbL18l9WzJI+PwyscURZ39UE62V2a9ku9SBwH3jvtN4bVBDs+ysJ1stMyHZgk16XgGu6xib4Wh2Qnjjxm7Vzw1kI+aiq5Npu+Z8C33RI26/3P4Ed8t/Vd0wq5qX8Q2kLmW9jB+S3pfSeEviHDmzu4GAAuAksyP8iyWChaFE8hCmaxrztSJn8HHVNlNPkaPiwLY4QO570HSfiCJnN0YDORAW4pzw7Y/UVl0JcWxA4fqkPuuDZzpQkoimOXYVUnccKcxpPDjrnijTRq7VH1cIYcat0EuJOGofVAxnPbAHY023SGJ79DqiCTeuIGghN05a19pSG6/2h8hs5+32Qo/I7Kq5WYAvGclJ+S06+RM7Q+vSwMS/ltwasbhc0oudzvpffhpK+I8YV6Gv5bSQYGf15YrroQbk1IavF2YmonKmqMtQzLL91cah0yokCBfg/+A0ArutLpCZBCQAAAABJRU5ErkJggg==">
              <em style="padding-right:10px">Close</em>
              <img height="35" width="35" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAACXBIWXMAAAsTAAALEwEAmpwYAAAB1klEQVR4nO2YzUocQRSFP8EfJP5CslA3gi/gxoDrgBsRTUCQZOXWqCgoiKtoAj5BII/gH7g1unY0MA7u1J1J3kBduGspOS2VRhc1QtEV7oGCPjN94XzcvjPVBSaTyWQymUymGGoB5oAT4BbISrpugWNgFmguQvQBZyUImQWuGtDrdyKHOAfGgXbKq3ZgArhQ5tO8M/MeRBfpqMuD+ew++CXjOpGaPii7mxluZMr8OD2nDmW/xhucVJXl+UNBvgPbwJD8gvzHwACrqnOD6zQpvxwL5Er35wE25TcCA+yrbkX+i/xebJCxAsi3OkGWCiC7sUB+6/5h+S35xcAAP1U3Lb8m/yMWyB/dPyC/Lf8pMMCB6kbl1+W/xgZxP30+yEidIG8LIPOxQP4Cd57fUf1gYIBD1fXLu044PxUTxHWlCOI2nvWAvCqAvIsF0uk9VihIN9AQGKBNdbla5RtfCpLiFqXzKZD8Dy7FTWOGd3GR4Db+8imQHOZ9YQbKpg51wof4B+S0BK+uWeDyMz/s5d3Fa71pHSdw+FABZoA3/vvIyX8w7BV0rJL6sM+gE4hawsNeBZryL3s9mJRWFegpkjZr2CvegUQZ1w1wpMfpsRMmk8lkMplMlE/3oAyuOSYFIKcAAAAASUVORK5CYII=">
              <em>Exact Match</em>
              
              `)
    
   
    const insightsMiddleware = instantsearch.middlewares.createInsightsMiddleware({
        insightsClient: aa,
    })

    var du = new DeviceUUID().parse();
    var dua = [
        du.language,
        du.platform,
        du.os,
        du.cpuCores,
        du.isAuthoritative,
        du.silkAccelerated,
        du.isKindleFire,
        du.isDesktop,
        du.isMobile,
        du.isTablet,
        du.isWindows,
        du.isLinux,
        du.isLinux64,
        du.isMac,
        du.isiPad,
        du.isiPhone,
        du.isiPod,
        du.isSmartTV,
        du.pixelDepth,
        du.isTouchScreen
    ];
    var uuid = du.hashMD5(dua.join(':'));
    aa("setUserToken", uuid)
    let currentIndex = -1;


    const search = instantsearch({
        indexName: getIndexName(),
        searchClient,
        searchFunction(helper) {
            currentIndex = -1;
            const container = document.querySelector('#hits');
            const stats = document.querySelector('#stats')
            const HitsPerPage = document.querySelector('#Hits-per-page');
            const menu = document.querySelector('#hierarchical-menu');
            const currentRefinements = document.querySelector('#current-refinements');
            const results_filter = document.querySelector('#results_filters');
            const header = document.querySelector('#header');
            const labelChoose = document.querySelector('#labelLocation')
            const recentsearchPanel = document.querySelector('#recentsearchPanel')
            recentsearchPanel.style.display = helper.state.query === '' ? 'none' : '';
            container.style.display = helper.state.query === '' ? 'none' : '';
            HitsPerPage.style.display = helper.state.query === '' ? 'none' : '';
            stats.style.display = helper.state.query === '' ? 'none' : '';
            menu.style.display = helper.state.query === '' ? 'none' : '';
            header.style.display = helper.state.query === '' ? 'none' : '';
            currentRefinements.style.display = helper.state.query === '' ? 'none' : '';
            results_filter.style.display = helper.state.query === '' ? 'none' : '';
            labelChoose.style.display = helper.state.query === '' ? 'none' : '';
            helper.search();
        },
        routing: instantSearchRouter, //Uncomment for proper URL routing for Autocomplete
        // routing: {
        //     stateMapping: {
        //         stateToRoute(uiState) {
        //             const indexUiState = uiState[getIndexName()];
        //             return {
        //                 q: indexUiState.query,
        //                 hitsPerPage: indexUiState.hitsPerPage,
        //                 page: indexUiState.page,
        //                 category: indexUiState.hierarchicalMenu && indexUiState.hierarchicalMenu['categories.lvl0'] && indexUiState.hierarchicalMenu['categories.lvl0'].join('~'),
        //                 locations: indexUiState.hierarchicalMenu && indexUiState.hierarchicalMenu['locations.lvl0'] && indexUiState.hierarchicalMenu['locations.lvl0'].join('~'),
        //                 //If you're using a standard menu instead of a hierarchical menu, use the following line instead:
        //                 location: indexUiState.menu && indexUiState.menu.location

        //             }
        //         },
        //         routeToState(routeState) {
        //             if (routeState.q !== undefined) { modal.open() }
        //             return {
        //                 [getIndexName()]: {
        //                     query: routeState.q,
        //                     //If you're using a standard menu instead of a hierarchical menu, use the following lines instead:
        //                     menu: {
        //                         location: routeState.location,
        //                     },
        //                     hierarchicalMenu: {
        //                         'categories.lvl0': routeState.category && routeState.category.split('~'),
        //                         'locations.lvl0': routeState.locations && routeState.locations.split('~'),
        //                     },
        //                     hitsPerPage: routeState.hitsPerPage,
        //                     page: routeState.page,
        //                 },
        //             };
        //         },
        //     },
        // },
    });



    search.use(insightsMiddleware)
    const sessionStorageCache = instantsearch.createInfiniteHitsSessionStorageCache();

    search.addWidgets([
        virtualSearchBox({}), //Uncomment this to Enable Autocomplete Search box
        instantsearch.widgets.configure({
            filters: filter,
            hitsPerPage: 8,
            facetingAfterDistinct: true,
        }),
        // instantsearch.widgets.searchBox({
        //     container: '#searchbox',
        //     searchAsYouType: false,
        //     showSubmit: true,
        //     placeholder: `Tap To Search`,
        
        // }),
        instantsearch.widgets.infiniteHits({
            container: '#hits',
            cache: sessionStorageCache,
            templates: {
                item(hit, bindEvent) {
                    let lang = hit && hit["locations.lvl1"] ? hit["locations.lvl1"].split(" > ")[1] : ''
                    switch (lang) {
                        case "cpp": lang = 'C++'; break;
                        case "cs": lang = 'C#'; break;
                        case '': lang = ''; break;
                    }
                    const langDiv = lang ? `<div class="hit-price" style="float:right">${lang}</div>` : '';
                    const location = hit.location ? `<div class="hit-location" style="float: left;">${hit.location}</div>` : '';
                    var type = hit.type ? `<div class="hit-location" style="float: left;">${hit.type}</div>` : '';
                    if(hit.type == "video") type = `<div class="hit-location video-tag" style="float: left;">Youtube video</div>`
                    var style = ""
                    switch (hit.product) {
                        case "HOOPS Communicator": style = "hc"; break;
                        case "HOOPS Exchange": style = "he"; break;
                        case "HOOPS Publish": style = "hp"; break;
                        case "HOOPS Visualize 3DF": style = "hv"; break;
                        case "HOOPS Visualize HPS": style = "hv"; break;
                        case "HOOPS Demo Viewer": style = "hnp"; break;
                        case "HOOPS Parasolid Demo Viewer": style = "hnp"; break;
                        case "CEETRON Solve/Access/Mesh": style = "ceesam"; break;
                        case "CEETRON Envision for Web": style = "ceetron"; break;
                        case "CEETRON Envision for Desktop":style = "ceetron"; break;
                        case "HOOPS Luminate": style = "hl"; break;
                    }
                    const searchbox = document.getElementById('searchbox');
                    const searchInput = searchbox.querySelector('input[class="aa-Input"]');
                    const product = hit.product ? `<div class="hit-product ${style}" style="float: left;">${hit.product}</div>` : '';
                    return `
  <a href='${MakeUrl(hit.url, searchInput.value)}'
    ${bindEvent('click', hit, 'Search Result Clicked')}
  >
    <img src="${findRelativeUrl(hit.image)}" align="left" alt="${hit.title}" role="${hit.type}" style="
    width: 100px;
"/>
    <div class="hit-name">
      ${instantsearch.highlight({ "attribute": "title", hit })}
    </div>
    <div class="hit-description">
      ${instantsearch.snippet({ "attribute": "body", hit })}
    </div>
    <div style="display:inline">
    ${product}
    ${type}
    ${location}
    ${langDiv}
    </div>
  </div>
`
                },
            },
        }),
        instantsearch.widgets.stats({
            container: '#stats',
            templates: {
                text(data, { html }) {
                    let count = '';

                    if (data.hasManyResults) {
                        count += `${data.nbHits} results`;
                    } else if (data.hasOneResult) {
                        count += `1 result`;
                    } else {
                        count += `no results`;
                    }
                    if(count == `no results`) {
                      document.querySelector('#hierarchical-menu').style.display = 'none'
                      document.querySelector('#header').style.display = 'none'
                      document.querySelector('#Hits-per-page').style.display = 'none'
                      document.querySelector('#results_filters').style["justify-content"] = 'center'
                      return html`<span><em>${count} found </em></span>`
                  }else{
                    document.querySelector('#results_filters').style["justify-content"] = 'space-between'
                    return html`<span><em>${count} found in ${data.processingTimeMS}ms</em></span>`;
                  }
                    
                },
            },
        }),
        instantsearch.widgets.hitsPerPage({
            container: '#Hits-per-page',
            items: [
                { label: '8 hits', value: 8, default: true },
                { label: '16 hits', value: 16 },
                { label: '32 hits', value: 32 },
                { label: '64 hits', value: 64 }
            ],
        }),
    ]);
// // Keyboard navigation event listener using event delegation


    if (hasOneTypeAndOneProduct(filter)) {

        if (project == "HOOPS Visualize HPS") {
            search.addWidgets([
                instantsearch.widgets.hierarchicalMenu({
                    container: '#hierarchical-menu',
                    attributes: [
                        'locations.lvl0',
                        'locations.lvl1',
                    ],
                    cssClasses: {
                        childList: ['MyCustomCssChild']
                    },
                    sortBy(a, b) {

                        if (a.name === "Getting Started") return -1;
                        if (a.name === 'Programming Guide' && b.name !== "Getting Started") return -1;
                        if (a.name === 'API Reference' && b.name !== "Getting Started" && b.name !== 'Programming Guide') return -1;
                        if (a.name === 'API REFERENCES' && b.name !== "Getting Started" && b.name !== 'API Reference' && b.name !== 'Programming Guide') return -1;
                        if (a.name === 'Additional Resources' && b.name !== 'API REFERENCES' && b.name !== "Getting Started" && b.name !== 'API Reference' && b.name !== 'Programming Guide') return -1;
                        if (a.name === "COMMON" && b.name !== "Getting Started") return -1;
                        if (a.name === 'DOCUMENTATION') return -1;
                        if (a.name === 'KNOWLEDGE BASE' && b.name !== "DOCUMENTATION") return -1;
                        if (a.name === 'COMMUNITY' && b.name !== "DOCUMENTATION" && b.name !== 'KNOWLEDGE BASE') return -1;
                        return 1;
                    },
                    templates: {
                        item(data, { html }) {
                            let { label, count, url, cssClasses } = data;
                        cssClasses.count = "ais-HitsCount"
                                                if (label === "cpp") { label = "C++"; cssClasses.link = "ais-CustomMenu-item"; cssClasses.label = "ais-CustomMenu-label"; cssClasses.count = "ais-CustomMenu-count"}
                                                if (label === "cs") { label = "C#"; cssClasses.link = "ais-CustomMenu-item1"; cssClasses.label = "ais-CustomMenu-label";cssClasses.count = "ais-CustomMenu-count" }
                                                
                                                return html`
                                            <a class="${cssClasses.link}" href="${url}">
                                        
                                            <span class="${cssClasses.label}" >${label}</span>
                                            <span class="${cssClasses.count}">${count}</span>
                                            </a>
                                        `;
                        },
                    },
                }),])

        } else {
            search.addWidgets([
                instantsearch.widgets.menu({
                    container: '#hierarchical-menu',
                    attribute: 'location',
                    sortBy(a, b) {

                        if (a.name === "Getting Started") return -1;
                        if (a.name === 'Tutorials' && b.name !== "Getting Started") return -1;
                        if (a.name === 'Programming Guide' && b.name !== "Getting Started" && b.name !== 'Tutorials') return -1;
                        if (a.name === 'API References' && b.name !== "Getting Started" && b.name !== 'Tutorials' && b.name !== 'Programming Guide') return -1;
                        if (a.name === 'DOCUMENTATION') return -1;
                        if (a.name === 'KNOWLEDGE BASE' && b.name !== "DOCUMENTATION") return -1;
                        if (a.name === 'COMMUNITY' && b.name !== "DOCUMENTATION" && b.name !== 'KNOWLEDGE BASE') return -1;
                        return 1;
                    },
                    templates: {
                        item(data, { html }) {
                            const { label, count, url, cssClasses } = data;

                            return html`
                    <a class="${cssClasses.link}" href="${url}">

                      <span class="${cssClasses.label}">${label}</span>
                      <span class="ais-HitsCount">${count}</span>
                    </a>
                  `;
                        },
                    },
                    transformItems(items) {
                        // Add hits count to each item
                        return items.map(item => {
                          const { count, ...rest } = item;
                          return {
                            count,
                            ...rest,
                          };
                        });
                    }
                }),
            ])
        }
    } else {

        search.addWidgets([
            instantsearch.widgets.hierarchicalMenu({
                container: '#hierarchical-menu',
                attributes: [
                    'categories.lvl0',
                    'categories.lvl1',
                    'categories.lvl2',
                    'categories.lvl3',
                ],maxValuesPerFacet: {
                    'categories.lvl0': 10000,
                    'categories.lvl1': 10000,
                    'categories.lvl2': 10000,
                    'categories.lvl3': 10000,
                },
                cssClasses: {
                    childList: ['MyCustomCssChild']
                },
                sortBy(a, b) {

                    if (a.name === "Getting Started") return -1;
                    if (a.name === 'Sample Code' && b.name !== "Getting Started") return -1;
                    if (a.name === 'Programming Guide' && b.name !== "Getting Started" && b.name !== 'Sample Code') return -1;
                    if (a.name === 'API References' && b.name !== "Getting Started" && b.name !== 'Sample Code' && b.name !== 'Programming Guide') return -1;
                    if (a.name === 'API REFERENCES' && b.name !== "Getting Started" && b.name !== 'Sample Code' && b.name !== 'Programming Guide') return -1;
                    if (a.name === 'Additional Resources' && b.name !== 'API References' && b.name !== "Getting Started" && b.name !== 'Sample Code' && b.name !== 'Programming Guide') return -1;
                    if (a.name === 'Envision Frameworks' && b.name !== 'Additional Resources' && b.name !== 'API References' && b.name !== "Getting Started" && b.name !== 'Sample Code' && b.name !== 'Programming Guide') return -1;
                    if (a.name === "GETTING STARTED") return -1;
                    if (a.name === "COMMON" && b.name !== "GETTING STARTED") return -1;
                    if (a.name === "CEETRON SOLVE" && b.name !== "COMMON" && b.name !== "GETTING STARTED") return -1;
                    if (a.name === "CEETRON ACCESS" && b.name !== "CEETRON SOLVE" && b.name !== "COMMON" && b.name !== "GETTING STARTED") return -1;
                    if (a.name === "CEETRON MESH" && b.name !== "CEETRON ACCESS" && b.name !== "CEETRON SOLVE" && b.name !== "COMMON" && b.name !== "GETTING STARTED") return -1;
                    if (a.name === "Legacy Visualization" && b.name !== "CEETRON MESH" && b.name !== "CEETRON ACCESS" && b.name !== "CEETRON SOLVE" && b.name !== "COMMON" && b.name !== "GETTING STARTED") return -1;
                    if (a.name === 'DOCUMENTATION') return -1;
                    if (a.name === 'KNOWLEDGE BASE' && b.name !== "DOCUMENTATION") return -1;
                    if (a.name === 'COMMUNITY' && b.name !== "DOCUMENTATION" && b.name !== 'KNOWLEDGE BASE') return -1;
                    return 1;
                },
                templates: {
                    item(data, { html }) {
                        let { label, count, url, cssClasses } = data;
                        var rootCount = 0
                        if(label == "DOCUMENTATION" && data.data){ 
                            
                            data.data.forEach(element => {
                                rootCount = rootCount + element.count 
                            });
                            if(rootCount > count){
                                count = rootCount
                            }
                        }
                        
                        cssClasses.count = "ais-HitsCount"
                        if (label === "cpp") { label = "C++"; cssClasses.link = "ais-CustomMenu-item"; cssClasses.label = "ais-CustomMenu-label"; cssClasses.count = "ais-CustomMenu-count"}
                        if (label === "cs") { label = "C#"; cssClasses.link = "ais-CustomMenu-item1"; cssClasses.label = "ais-CustomMenu-label";cssClasses.count = "ais-CustomMenu-count" }
                        
                        return html`
                    <a class="${cssClasses.link}" href="${url}">
                  
                      <span class="${cssClasses.label}" >${label}</span>
                      <span class="${cssClasses.count}">${count}</span>
                    </a>
                  `;
                    },
                },
                transformItems(items) {
                    // Add hits count to each item
                    return items.map(item => {
                      const { count, ...rest } = item;
                      return {
                        count,
                        ...rest,
                      };
                    });
                }
            }),
            instantsearch.widgets.currentRefinements({
                container: '#current-refinements',
                transformItems(items) {
                    if (items[0]) items[0].label = "Location"
                    return items
                },
            }),
        ])
    }
    search.on('render', () => {
      const resetButton = document.querySelector('.aa-ClearButton');
      
      document.querySelector('#autocomplete-0-input')._listeners.keydown = null
      if (resetButton) {
        resetButton.className = "ais-SearchBox-reset";
        resetButton.addEventListener('click', () => {
          search.helper.setQuery('');
          search.helper.clearRefinements();
          search.helper.search();
        });
      }
    });
    search.start();
//Navigation for keyboard
    document.addEventListener('keydown', event => {
      if (modal.isOpen() && (document.querySelector('.ais-InfiniteHits-list') || document.querySelector('.aa-List'))) {
          const resultItems = document.querySelectorAll('.ais-InfiniteHits-item');
    
          switch (event.key) {
              case 'ArrowUp':
                  event.preventDefault();
                  setFocus(currentIndex - 1, resultItems);
                  break;
              case 'ArrowDown':
                  event.preventDefault();
                  setFocus(currentIndex + 1, resultItems);
                  break;
              case 'Enter':
                  event.preventDefault();
                  if (currentIndex >= 0 && currentIndex < resultItems.length) {
                      const focusedItem = resultItems[currentIndex];
                      
                      // Check if the focused element has the class .aa-Item
                      if (focusedItem.classList.contains('aa-Item')) {
                        
                          // Get the content of the focused .aa-Item
                          const itemContent = focusedItem.textContent.trim();
                          // Set the input field value to the content
                          const inputField = document.getElementById('autocomplete-0-input');
                          if (inputField) {
                            setInstantSearchUiState({ query: itemContent})
                            search.helper.clearRefinements();
                            inputField.value = itemContent;
                            currentIndex = -1;
                            search.helper.setQuery(itemContent);
                              // Create a new 'input' event
                            var event = new Event('input', {
                              bubbles: true,
                              cancelable: true,
                            });

                            // Dispatch the 'input' event, this will cause the suggestions to update
                            inputField.dispatchEvent(event);
                          }
                      } else {
                          // If not a .aa-Item, navigate to the result link
                          focusedItem.querySelector('a').click();
                      }
                  }
                  break;
          }
      }
    });
    
    // Function to set focus on a result item
    function setFocus(index, resultItems) {
        if (index < 0) {
            index = resultItems.length - 1;
        } else if (index >= resultItems.length) {
            index = 0;
        }
    
        resultItems.forEach(item => item.classList.remove('focused'));
        resultItems.forEach(item => item.setAttribute('aria-selected', 'false'));
        resultItems[index].classList.add('focused');
        resultItems[index].setAttribute('aria-selected', 'true'); // Remove the tabindex from the previous focused result item
        resultItems[index].focus();
    
        currentIndex = index; // Remember the current index
        // Scroll the focused result item into view
        resultItems[index].scrollIntoView({ behavior: 'smooth', block: 'center' });
    }

    ///Autocomplete Integration starts here : WIP

//     // Set the InstantSearch index UI state from external events.
function setInstantSearchUiState(indexUiState) {
  
    search.setUiState(uiState => ({
      ...uiState,
      [getIndexName()]: {
        ...uiState[getIndexName()],
        // We reset the page when the search state changes.
        page: 1,
        ...indexUiState,
      },
    }));
    
  }
//   // Return the InstantSearch index UI state.
function getInstantSearchUiState() {
    const uiState = instantSearchRouter.read();
    if(uiState && uiState[getIndexName()]) modal.open()
    return (uiState && uiState[getIndexName()]) || {};
  }
  const searchPageState = getInstantSearchUiState();

let skipInstantSearchUiStateUpdate = false;

//   // This keeps Autocomplete aware of state changes coming from routing
// // and updates its query accordingly
window.addEventListener('popstate', () => {
    skipInstantSearchUiStateUpdate = true;
    setQuery(search.helper?.state.query || '');
    
  });
//   // Build URLs that InstantSearch understands.
function getInstantSearchUrl(indexUiState) {
    return search.createURL({ [getIndexName()]: indexUiState });
  }
//   // Detect when an event is modified with a special key to let the browser
// // trigger its default behavior.
function isModifierEvent(event) {
    const isMiddleClick = event.button === 1;
  
    return (
      isMiddleClick ||
      event.altKey ||
      event.ctrlKey ||
      event.metaKey ||
      event.shiftKey
    );
  }
  function onSelect({ setIsOpen, setQuery, event, query }) {
    // You want to trigger the default browser behavior if the event is modified.
    if (isModifierEvent(event)) {
      return;
    }
    setQuery(query);
    setIsOpen(false);
    setInstantSearchUiState({ query });
  }
  
  function getItemUrl({ query }) {
    return getInstantSearchUrl({ query });
  }
  
  function createItemWrapperTemplate({ children, query, html }) {
    const uiState = { query };
   
    return html`<a
      class="aa-ItemLink"
      href="${getInstantSearchUrl(uiState)}"
      onClick="${(event) => {
        if (!isModifierEvent(event)) {
          // Bypass the original link behavior if there's no event modifier
          // to set the InstantSearch UI state without reloading the page.
          event.preventDefault();
        }
      }}"
    ><div class="aa-Hit-container">
      ${children}
      </div>
    </a>`;
  }
  //This activates recent searches
  // const recentSearchesPlugin = createLocalStorageRecentSearchesPlugin({
  //   key: 'recent-searches',
  //   limit: 5,
  //   transformSource({ source }) {
  //     return {
  //       ...source,
  //       getItemUrl({ item }) {
  //         return getItemUrl({
  //           query: item.label,
  //         });
  //       },
  //       onSelect({ setIsOpen, setQuery, item, event }) {
  //         onSelect({
  //           setQuery,
  //           setIsOpen,
  //           event,
  //           query: item.label,
  //         });
  //       },
  //       // Update the default `item` template to wrap it with a link
  //       // and plug it to the InstantSearch router.
  //       templates: {
  //         ...source.templates,
  //         item(params) {
  //           const { children } = source.templates.item(params).props;
            
  //           return createItemWrapperTemplate({
  //             query: params.item.label,
  //             children,
  //             html: params.html,
  //           });
  //         },
  //       },
  //     };
  //   },

  // });
 const querySuggestionsPlugin = createQuerySuggestionsPlugin({
  searchClient,
  indexName: 'Production_query_suggestions',
  transformSource({ source }) {
    return {
      ...source,
      getItemUrl({ item }) {
        return getItemUrl({
          query: item.query,
        });
      },
      onSelect({ setIsOpen, setQuery, item, event }) {
        //clear filters when selecting another query
        search.helper.clearRefinements();
        onSelect({
          setQuery,
          setIsOpen,
          event,
          query: item.query,
        });
      },
      // Update the default `item` template to wrap it with a link
      // and plug it to the InstantSearch router.
      templates: {
        ...source.templates,
        item(params) {
          const { children } = source.templates.item(params).props;
          search.helper.clearRefinements();
          return createItemWrapperTemplate({
            query: params.item.query,
            children,
            html: params.html,
          });
        },
      },
    };
  },

});

 const type = extractTypeAndProduct(filter).type
  const product = extractTypeAndProduct(filter).product
  const { setQuery } = autocomplete({
    container: '#searchbox',
    placeholder: 'Tap To Search',
    panelContainer: '#recentsearchPanel',
    detachedMediaQuery: 'none',  // You want recent searches to appear with an empty query.
    //openOnFocus: true,
    autoFocus: true,
    insights: true,
    classNames:{
      item:'ais-InfiniteHits-item',
    },
    // Add the recent searches plugin.
    //plugins: [recentSearchesPlugin],  
    //plugins: [querySuggestionsPlugin],
    initialState: {
      query: searchPageState.query || '',
    },
    onSubmit({ state }) {
      setInstantSearchUiState({ query: state.query });
    },
    onReset() {
      
      currentIndex = -1;
      search.helper.clearRefinements();
      setInstantSearchUiState({ query: '' });
    },
    onStateChange({ prevState, state }) {
      
      search.helper.clearRefinements();
        if (state.query.length < 3 && state.query.length > 0) {
            return; // no search if less than X characters
          }
          
          if (!skipInstantSearchUiStateUpdate && prevState.query !== state.query) {
            if(document.querySelector('.aa-Item') && document.querySelector('.ais-InfiniteHits-item')){
            var firstHitIndex = document.querySelectorAll('.aa-Item').length 
            const resultItems = document.querySelectorAll('.ais-InfiniteHits-item');
            resultItems[firstHitIndex].scrollIntoView({ behavior: 'smooth', block: 'center' });
            currentIndex = firstHitIndex;
          }
            delay(300).then(() => setInstantSearchUiState({ query: state.query }));
          }

      skipInstantSearchUiStateUpdate = false;
    }, navigator: {
      
    },  getSources({ query }) {
      if (query.length >= 3) {
        return [
          { 
            sourceId: 'querySuggestions',
            getItemInputValue: ({ item }) => item.query,
            getItems() {
              return getAlgoliaResults({
                searchClient,
                queries: [
                  {
                    indexName: 'Production_query_suggestions',
                    query,
                    params: {
                      hitsPerPage: 5,
                      filters: generateQuerySuggestionFilters(type, product),
                    },
                  },
                ],
              });
            },
            templates: {
                item({ item, components, html }) {
                  //return components.ReverseHighlight({ hit: item, attribute: 'query' });
                  return html`<div class="aa-ItemLink"><div class="aa-Hit-container">
                  ${components.ReverseHighlight({ hit: item, attribute: 'query' })}
                  </div></div>
                `;
                },
              },
            
          },
        ];
      }
      }, 
  })

    }
let timeoutId;

function delay(t, v) {
  return new Promise(function(resolve) {
    clearTimeout(timeoutId);
    timeoutId = setTimeout(resolve.bind(null, v), t);
  });
}


 });

 //extract type and product from filter
 //for type : "Documentation page" AND product :"CEETRON Envision for Web"  returns type="Documentation page" and product="CEETRON Envision for Web"
//for type:"Documentation page" AND product:"CEETRON Envision for Web" returns type="Documentation page" and product="CEETRON Envision for Web"
//for (type:"Documentation page") AND (product:"CEETRON Envision for Web") returns type="Documentation page" and product="CEETRON Envision for Web"
//for Not product:"Dummy" returns type="" and product=""

function extractTypeAndProduct(filter) {
  let type = ''
  let product = ''
  let typeRegex = /type\s*:\s*\"(.*?)\"/g
  let productRegex = /product\s*:\s*\"(.*?)\"/g
  let typeMatch = typeRegex.exec(filter)
  let productMatch = productRegex.exec(filter)
  if (typeMatch) type = typeMatch[1]
  if (productMatch) product = productMatch[1]
  return { type, product }
}

//generate query suggestion filters given a type and product
//for type != "" and product != "Dummy" and product != "" returns ' Production.facets.exact_matches.type.value : ${type} and Production.facets.exact_matches.product.value: ${product} '
//otherwise return ''

function generateQuerySuggestionFilters(type, product) {
  if (type != "" && product != "Dummy" && product != "") {
    return ` Production.facets.exact_matches.type.value : "${type}" AND Production.facets.exact_matches.product.value: "${product}" `
  }
  return ''
}