var thread_id = null;
var isWaitingForResponse = false;
// Configuration globale
let isPaused = false;
let currentCharCount = 0;
const maxCharsBeforePause = 2000;
let shouldAutoScroll = true;  // Control whether autoscroll is active
var sharedThreadId = null;

let speed = 10; // Speed of the typewriter effect in milliseconds
// Flag to indicate whether to complete typing immediately
let shouldCompleteTypingImmediately = false;
var urlRoot = null;
let stage = 'Production';
// Event Listeners and interaction helpers
document.addEventListener("DOMContentLoaded", function() {
    urlRoot = typeof Path_ROOT !== 'undefined' ? Path_ROOT : document.querySelector('#documentation_options').getAttribute('data-url_root');
    // Get the tooltip element by class name
    var tooltip = document.querySelector('.tooltiptext');    
    // Hide the share button initially
    hideShareButton();
    // Check if the tooltip element exists
    if (tooltip) {
        // Add the fade-in class to make it visible
        tooltip.classList.add('fade-in');

        // Set a timeout to add the fade-out class after the fade-in completes and some delay
        setTimeout(function() {
            tooltip.classList.remove('fade-in');
            tooltip.classList.add('fade-out');
        }, 3000); // Adjust the delay (in milliseconds) as needed
    } else {
        console.error('Tooltip element not found');
    }
    // Ajouter un événement pour le bouton "Continuer de générer"
    // document.getElementById('continue-button').addEventListener('click', continueTyping);
    const urlParams = new URLSearchParams(window.location.search);
    sharedThreadId = urlParams.get('thread_id');
    const storedThreadData = localStorage.getItem('threadData');

    if (sharedThreadId) {
        loadThread(sharedThreadId,true);
        if(storedThreadData) localStorage.removeItem('threadData');
    }
    // Determine the environment and select the appropriate vectorstore
    const currentUrl = window.location.hostname;
    const isProduction = currentUrl === "docs.techsoft3d.com";
    // Retrieve the correct assistantId and vectorstore based on the project
    assistantId = configMap[chat_project].assistantId || {}; 
    vectorstore = configMap[chat_project].vectorstore || {}; 
    vectorstore = isProduction ? vectorstore.production : vectorstore.staging;
    stage = isProduction ? 'Production' : 'Testing';
    // Ajouter un événement pour le bouton "Stop"
    document.getElementById('stop-button').addEventListener('click', stopTyping);
    const chatBody = document.getElementById('chat-body');
    // Attach scroll event listener to chat body
    chatBody.addEventListener('scroll', handleUserScroll);
    const shareButton = document.getElementById('share-conversation-button');
    if (shareButton) {
        shareButton.addEventListener('click', shareConversation);
    }

    // Check for stored thread_id in localStorage
    
    if (storedThreadData && !sharedThreadId) {
        const threadData = JSON.parse(storedThreadData);
        const currentTime = new Date().getTime();
        const timeDifference = currentTime - threadData.timestamp;

        if (timeDifference < 15 * 60 * 1000) {
            // thread_id is valid, load the thread
            thread_id = threadData.thread_id;
            loadThread(thread_id,false);
        } else {
            // thread_id expired, remove it
            localStorage.removeItem('threadData');
        }
    }
});

document.addEventListener('visibilitychange', function() {
    if (document.hidden) {
        // Page is not visible
        speed = 0;
        shouldCompleteTypingImmediately = true;
    } else {
        // Page is visible
        speed = 10; // Reset typing speed
        shouldCompleteTypingImmediately = false;
    }
});

// Make the chat container header draggable within the viewport

interact('.chat-header').draggable({
    inertia: true,
    modifiers: [
        interact.modifiers.restrict({
            restriction: {
                top: 50,
                left: 20,
                right: 20,
                bottom:20,
                bottom: window.innerHeight,
                right: window.innerWidth
            },
            endOnly: true, // Restrict only at the end of the drag
        }),
        interact.modifiers.restrictEdges({
            outer: {
                top: 50,
                left: 20,
                right: 20,
                bottom:20,
                bottom: window.innerHeight,
                right: window.innerWidth
            }, // Restrict movement within the parent container
            endOnly: true, // Restrict only at the end of the drag
        })
    ],
    listeners: {
        move(event) {
            const target = event.target.closest('.chat-container');
            let x = (parseFloat(target.getAttribute('data-x')) || 0) + event.dx;
            let y = (parseFloat(target.getAttribute('data-y')) || 0) + event.dy;

            target.style.transform = `translate(${x}px, ${y}px)`;
            target.setAttribute('data-x', x);
            target.setAttribute('data-y', y);
        }
    }
});
// Function to share the current conversation by creating a link with thread_id
function shareConversation() {
    if (!thread_id) {
        alert("No conversation to share!");
        return;
    }

    const currentUrl = window.location.href.split('?')[0]; // Remove existing query parameters
    const shareableLink = `${currentUrl}?thread_id=${encodeURIComponent(thread_id)}`;
    const shareButton = document.querySelector("#share-conversation-button");
    const uploadIcon = document.getElementById('upload-icon');
    const checkmarkIcon = document.getElementById('checkmark-icon');
    const textElement = shareButton.querySelector('.button-text');
    const originalText = textElement.textContent;

    // Copy the link to clipboard
    navigator.clipboard.writeText(shareableLink).then(function() {
        // Swap the icons
        uploadIcon.style.display = 'none';
        checkmarkIcon.style.display = 'inline-block';
        shareButton.style.background = "#0972d3";
        // Change the text to "Shared"
        textElement.textContent = "Link copied";

        // After 5 seconds, revert back
        setTimeout(function() {
            // Swap the icons back
            checkmarkIcon.style.display = 'none';
            uploadIcon.style.display = 'inline-block';
            shareButton.style.removeProperty('background');

            // Revert the text back to "Share"
            textElement.textContent = originalText;
        }, 3000);
    }, function(err) {
        console.error('Could not copy text: ', err);
    });
}


// Function to load a thread by threadId
async function loadThread(threadId,useNewThread) {
    showLoadingIndicator();

    try {
        const data = await fetchThread(threadId);
        if(useNewThread) thread_id = null;
        if(!useNewThread) thread_id=threadId; // Update the global thread_id
        // Clear existing chat messages
        // Display each message
        toggleChat()
        hideFirstTimeConvo()
        data.messages.reverse()
        data.messages.forEach(message => {
            const sender = isUserMessage(message) ? 'user' : 'assistant';
            const marked = sender === 'assistant'; // true for assistant messages
            const useTypewriter = false;
            // Use message.references instead of data.references
            displayMessage(message.content,message.file_ids || [], message.references || [], sender, marked, useTypewriter);
        });
        showNewConversationButton();
    } catch (error) {
        console.error('Error loading thread:', error);
        displayMessage("Failed to load the conversation. Please try again later or start a new conversation.",[], [], 'assistant', true);
        showNewConversationButton();
    } finally {
        hideLoadingIndicator();
    }
}

// Function to determine if a message is from the user
function isUserMessage(message) {
    return message.role === 'user';
}

// Function to fetch a thread by threadId from the Lambda function
async function fetchThread(threadId) {
    const response = await fetch(`https://swwlbpszod.execute-api.eu-west-3.amazonaws.com/${stage}/SendChat`, { // Replace with your API endpoint
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            body: JSON.stringify({
            action: 'getThread',
            threadId: threadId,
            product: chat_project 
        })
    })
    });

    if (!response.ok) {
        throw new Error(`HTTP error! Status: ${response.status}`);
    }

    const data = await response.json();
    data.body = JSON.parse(data.body);
    return data.body;
}

// Function to show a loading indicator
function showLoadingIndicator() {
    const loadingIndicator = document.getElementById('loadingIndicator');
    if (loadingIndicator) {
        loadingIndicator.style.display = 'block';
    }
}

// Function to hide the loading indicator
function hideLoadingIndicator() {
    const loadingIndicator = document.getElementById('loadingIndicator');
    if (loadingIndicator) {
        loadingIndicator.style.display = 'none';
    }
}
function checkInput() {
    const userInput = document.getElementById('user-input');
    const sendButton = document.getElementById('send-button');

    if (userInput.value.trim() !== '') {
        sendButton.classList.add('active');
    } else {
        sendButton.classList.remove('active');
    }
    var maxLength = 1000;
    var currentLength = document.getElementById('user-input').value.length;
    var remaining = maxLength - currentLength;
    document.getElementById('char-count').innerText = remaining + ' characters left';
}


function handleQuestionButtonClick(button) {
    const question = button.innerText;
    sendMessage(question);
}
function hideFirstTimeConvo() {
    const firstTimeConvos = document.getElementsByClassName('first-time-convo');
    for (const firstTimeConvo of firstTimeConvos) {
        firstTimeConvo.style.display = 'none'; // Hide the first-time-convo div
    }
}

function showFirstTimeConvo() {
    const firstTimeConvos = document.getElementsByClassName('first-time-convo');
    for (const firstTimeConvo of firstTimeConvos) {
        firstTimeConvo.style.display = 'block'; // Show the first-time-convo div
    }
}

function NewConversation() {
    const newConversationButton = document.getElementById('new-conversation-button');
    const suggestionPopup = document.getElementById('suggestionPopup');
    const loading = document.getElementById('loadingIndicator');
    const chatFooter = document.querySelector('.chat-footer');    
    const userInputElement = document.getElementById('user-input');
    const sendButton = document.getElementById('send-button');
    sendButton.querySelector('i').style.display = 'block';
    sendButton.querySelector('.loader').style.display = 'none';
    sendButton.classList.remove('active');
    sendButton.querySelector('.stop-button').style.display = 'none';
    // **Reset thread_id**
    thread_id = null;
    sharedThreadId = null
    // **Remove thread_id parameter from the URL**
    const url = new URL(window.location);
    url.searchParams.delete('thread_id');
    window.history.replaceState({}, document.title, url.pathname + url.search);
    userInputElement.disabled = false;
    sendButton.disabled = false;
    isWaitingForResponse = false;
    isPaused=true;
    // **Hide the share button**
    hideShareButton()
    document.getElementById('chat-body').innerHTML = '<div class="first-time-convo" id="suggestionPopup">'+suggestionPopup.innerHTML+'</div>';
    loading.style.display='none';
    document.getElementById('chat-body').append(loading)
    newConversationButton.style.display = 'none';
    //  document.getElementById('chat-body').parentNode.insertBefore(newConversationButton, chatFooter);

    // Remove thread_id from localStorage
    localStorage.removeItem('threadData');
}
let conversationMessages = [];

// Function to display messages with a loading indicator
// Function to display messages with a loading indicator
async function displayMessage(
    message,
    refId = [],
    refUrls = [],
    sender,
    isMarked = false,
    useTypewriter = true
) {
    // Create the message container
    const messageContainer = document.createElement('div');
    messageContainer.className = `message ${sender}`;

    // Text element to hold the content
    const textElement = document.createElement('div');
    textElement.className = 'text';
    messageContainer.appendChild(textElement);

    const chatBodyContainer = document.getElementById('chat-body');
    const loadingIndicator = chatBodyContainer.querySelector('.loading-indicators');
    // Insert the message container in the chat body before the loading dots
    loadingIndicator.parentNode.insertBefore(messageContainer, loadingIndicator);

    // Parse the message content
    const parsedMessage = isMarked
        ? marked.parse(message)
        : marked.parse(message.replace('!', '! '), { breaks: true });

    const tempElement = document.createElement('div');
    tempElement.innerHTML = parsedMessage;

    if (sender === 'assistant') {
        if (useTypewriter && speed > 0) {
            typeWriter(tempElement, textElement, () => {
                // After typing, highlight code blocks and handle references
                handlePostMessageDisplay(messageContainer, refUrls);
                resetUIState();
            });
        } else {
            // Display the message instantly
            textElement.innerHTML = tempElement.innerHTML;
            handlePostMessageDisplay(messageContainer, refUrls);
            resetUIState();
        }

        // Show share button if thread_id exists
        if (thread_id) {
            showShareButton();
            showNewConversationButton();
        }
    } else {
        // For user messages, display the text directly
        isPaused = false; // Writing can resume since the user sent a new message
        textElement.innerHTML = marked.parse(message);
    }

    // Add the message to conversationMessages
    conversationMessages.push({
        role: sender,
        content: message.trim(),
        attachment: refId,
    });
}
async function handlePostMessageDisplay(messageContainer, refUrls) {
    // Highlight code blocks
    const codeBlocks = messageContainer.querySelectorAll('pre code');
    codeBlocks.forEach((el) => {
        createCodeBlockHeader(el);
        hljs.highlightElement(el); // Highlight the code block
    });

    // Handle references
    for (const url of refUrls) {
        const title = await fetchHtmlTitle(urlRoot + url);
        const linkHolder = document.createElement('div');
        linkHolder.innerText = `${title}`;
        linkHolder.onclick = () => window.open(urlRoot + url, '_blank');
        linkHolder.className = 'chat-ref';
        messageContainer.appendChild(linkHolder);
    }
}
function resetUIState() {
    // Enable input and reset UI elements
    const sendButton = document.getElementById('send-button');
    const userInputElement = document.getElementById('user-input');
    const stopButton = document.getElementById('stop-button');
    stopButton.style.display = 'none';
    sendButton.querySelector('i').style.display = 'block';
    sendButton.querySelector('.loader').style.display = 'none';
    sendButton.classList.remove('active');
    userInputElement.disabled = false;
    sendButton.disabled = false;
    isWaitingForResponse = false;
}

// Function to detect if user scrolls manually
function handleUserScroll() {
    const chatBody = document.getElementById('chat-body');
    const scrollTop = chatBody.scrollTop;
    const scrollHeight = chatBody.scrollHeight;
    const clientHeight = chatBody.clientHeight;
    // Check if the user is at the bottom (allowing a small buffer)
    shouldAutoScroll = (scrollTop + clientHeight >= scrollHeight - 10);
    // console.log("ShouldAutoScroll : "+shouldAutoScroll)
}


function completeTyping() {
    isPaused = false; // Ensure typing is not paused
    speed = 0; // Set speed to 0 to complete typing immediately
    shouldCompleteTypingImmediately = true;
}
function getDistanceBetweenElements(element1, element2) {
    const rect1 = element1.getBoundingClientRect();
    const rect2 = element2.getBoundingClientRect();
    return rect1.top - rect2.bottom;
}
// Function to autoscroll to the bottom only if shouldAutoScroll is true
function autoScroll() {
    const chatBody = document.getElementById('chat-body');
    const chatHeader = document.querySelector('.chat-header');
    const userMessages = chatBody.querySelectorAll('.message.user');
    const userMessage = userMessages[userMessages.length - 1];
    const distance = getDistanceBetweenElements(userMessage, chatHeader);
    if (shouldAutoScroll && distance >15) {
        chatBody.scrollTop = chatBody.scrollHeight;
    }
}
// Typewriter function with pause control
// Typewriter function with pause control
function typeWriter(element, parentElement, callback) {
    let childNodes = Array.from(element.childNodes);
    let i = 0;

    function typeNextNode() {
        if (isPaused) return; // Stop typing if paused

        if (i < childNodes.length) {
            const node = childNodes[i];
            i++; // Move to the next node

            if (node.nodeType === Node.TEXT_NODE) {
                typeTextNode(node, parentElement, typeNextNode);
            } else if (node.nodeType === Node.ELEMENT_NODE) {
                typeElementNode(node, parentElement, typeNextNode);
            }
        } else if (callback) {
            callback(); // All nodes processed
        }
    }

    function typeTextNode(node, parentElement, callback) {
        const text = node.textContent;
        let j = 0;

        function typeChar() {
            if (isPaused) return; // Stop typing if paused

            // Check if we should complete typing immediately
            if (shouldCompleteTypingImmediately) {
                appendText(parentElement, text.substring(j));
                if (callback) callback();
                return;
            }

            if (j < text.length) {
                appendText(parentElement, text.charAt(j));
                j++;
                setTimeout(typeChar, speed); // Continue typing
            } else if (callback) {
                callback(); // Move to next node
            }
            autoScroll()
        }

        typeChar();
    }

    function appendText(parentElement, text) {
        const tagName = parentElement.nodeName.toLowerCase();
        if (tagName === 'code' || tagName === 'pre') {
            parentElement.textContent += text;
        } else {
            parentElement.innerHTML += text;
        }
    }

    function typeElementNode(node, parentElement, callback) {
        const newElement = document.createElement(node.nodeName);

        // Copy attributes
        for (const attr of node.attributes) {
            newElement.setAttribute(attr.name, attr.value);
        }

        parentElement.appendChild(newElement);

        // Check if we should complete typing immediately
        if (shouldCompleteTypingImmediately) {
            typeWriter(node, newElement, () => {
                if (node.nodeName.toLowerCase() === 'code') {
                    hljs.highlightElement(newElement);
                }
                if (callback) callback();
            });
        } else {
            setTimeout(() => {
                typeWriter(node, newElement, () => {
                    if (node.nodeName.toLowerCase() === 'code') {
                        hljs.highlightElement(newElement);
                    }
                    if (callback) callback();
                });
            }, speed);
        }
    }
    typeNextNode();
}
// Function to create the header for code blocks (for language label and copy button)
function createCodeBlockHeader(el) {
    // Check if the parent is a <pre> element (i.e., a code block)
    if (el.parentNode && el.parentNode.nodeName.toLowerCase() === 'pre') {
        el.parentNode.style.position ="relative"
        const codeBlockHeader = document.createElement('div');
        codeBlockHeader.className = 'code-header';

        // Language label
        let language = el.className.replace('language-', '').replace(' hljs', '').trim();
        if (!language || language === 'undefined') {
            language = 'plaintext'; // Default to 'plaintext' if no language specified
        }
        const languageLabel = document.createElement('span');
        languageLabel.className = 'language-label';
        languageLabel.textContent = language;
        // Tooltip element
        const tooltip = document.createElement('span');
        tooltip.className = 'copy-tooltip';
        tooltip.textContent = 'Copied!';
        tooltip.style.display = 'none';
        tooltip.style.color = 'rgb(36, 221, 36)';
        // Copy button
        const copyButton = document.createElement('button');
        copyButton.className = 'copy-button';
        copyButton.innerHTML = '<img src="' + urlRoot + '_static/images/copy.png" class="copy-img" alt="Copy to clipboard"></img>';
        el.id = `code-block-${Math.random().toString(36).substr(2, 9)}`;
        copyButton.setAttribute('data-clipboard-target', `#${el.id}`);
        // Append label and button to header, and header to the code block
        el.parentNode.insertBefore(codeBlockHeader, el);
        codeBlockHeader.appendChild(languageLabel);
        codeBlockHeader.appendChild(copyButton);
        codeBlockHeader.appendChild(tooltip);
        // Initialize ClipboardJS for the new copy button with dynamic text retrieval
        const clipboard = new ClipboardJS(copyButton, {
            text: function() {
                return el.innerText;
            }
        });
    
        // Show tooltip on successful copy
        clipboard.on('success', function(e) {
            tooltip.style.display = 'inline';
            // Hide the tooltip after 5 seconds
            setTimeout(function() {
                tooltip.style.display = 'none';
            }, 2000);
            e.clearSelection();
        });
    }
}

function showShareButton() {
    const shareButton = document.getElementById('share-conversation-button');
    if (shareButton) {
        shareButton.style.display = 'inline-flex';
    }
}

function hideShareButton() {
    const shareButton = document.getElementById('share-conversation-button');
    if (shareButton) {
        shareButton.style.display = 'none';
    }
}
// Function to display the button "Continue Generation"
function showContinueButton() {
    const continueButton = document.getElementById('continue-button');
    continueButton.style.display = 'inline-block';
}

// Fonction pour reprendre le typewriter
function continueTyping() {
    isPaused = false;
    document.getElementById('continue-button').style.display = 'none';
    currentCharCount = 0;
    typeWriter(); 
}

// Modifier la fonction sendMessage pour gérer les indicateurs de chargement et le bouton stop
async function sendMessage(predefinedMessage = null) {
    if (isWaitingForResponse) return;
    const userInputElement = document.getElementById('user-input');
    const userInput = predefinedMessage || userInputElement.value.trim();
    const sendButton = document.getElementById('send-button');
    document.getElementById('char-count').style.display = "none"
    if (!userInput) return;
    hideFirstTimeConvo();

    displayMessage(userInput,[], [], 'user');
    userInputElement.value = '';
    document.getElementById('chat-body').scrollTop = document.getElementById('chat-body').scrollHeight;

    // Replace the send button with loading indicators
    sendButton.querySelector('i').style.display = 'none';
    sendButton.querySelector('.loader').style.display = 'block';
    document.getElementById('chat-body').querySelector('.loading-indicators').style.display = 'block'; // Display the loading icon

    userInputElement.disabled = true;
    sendButton.disabled = true;
    isWaitingForResponse = true;

    try {
        // Check if we're viewing a shared thread
        if (sharedThreadId) {
            // Create a new thread and copy messages
            thread_id = await createNewThreadWithMessages(sharedThreadId);
            // Remove 'thread_id' from URL to avoid confusion
            const url = new URL(window.location);
            url.searchParams.delete('thread_id');
            window.history.replaceState({}, document.title, url.pathname + url.search);
            // Reset sharedThreadId since we're now on a new thread
            sharedThreadId = null;
        }
        const data = await chat(userInput, thread_id);
        thread_id = data.thread_id;
        let refurls = data.refurls;
        let refIds = data.file_ids
        // Remplacer les indicateurs de chargement par un bouton "Stop"
        document.getElementById('chat-body').querySelector('.loading-indicators').style.display = 'none';
        sendButton.querySelector('.stop-button').style.display = 'block';
        sendButton.querySelector('.loader').style.display = 'none';

        displayMessage(data.messages[0],refIds, refurls, 'assistant');
        storeThreadId();
    } catch (error) {
        displayMessage("I'm experiencing technical issues at the moment. I'll be back as soon as possible. Please start a new conversation to try again.",[], [], 'assistant', true);
        document.getElementById('chat-body').querySelector('.loading-indicators').style.display = 'none';
        showNewConversationButton();
        isWaitingForResponse = false;
    }
}
async function createNewThreadWithMessages(sharedThreadId) {
    try {
        //remove the last message from the conversationMessages array to avoid duplication
        conversationMessages.splice(-1)
        // Use the messages stored in conversationMessages
        const sharedMessagesData = conversationMessages;
        // Create a new thread
        const newThreadId = await createNewThread();

        // Copy messages to the new thread
        for (const message of sharedMessagesData) {
            await addMessageToThread(newThreadId, message);
        }

        return newThreadId;
    } catch (error) {
        console.error('Error creating new thread with messages:', error);
        throw error;
    }
}

// Function to create a new thread
async function createNewThread() {
    const response = await fetch(`https://swwlbpszod.execute-api.eu-west-3.amazonaws.com/${stage}/SendChat`, { // Replace with your API endpoint
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({body: JSON.stringify({
            action: 'createThread',
            model: model,
            assistantId: assistantId,
            vectorstore: vectorstore,
            product: chat_project 
        })})
    });

    const data = await response.json();

    data.body = JSON.parse(data.body);
    if (!response.ok) {
        throw new Error(data.error || 'Failed to create new thread');
    }

    return data.body.thread_id;
}

// Function to add a message to a thread
async function addMessageToThread(threadId, message) {
    const response = await fetch(`https://swwlbpszod.execute-api.eu-west-3.amazonaws.com/${stage}/SendChat`, { // Replace with your API endpoint
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({body: JSON.stringify({
            action: 'addMessage',
            threadId: threadId,
            role: message.role,
            content: message.content,
            attachments: message.attachment,
            product: chat_project
        })})
    });

    if (!response.ok) {
        const data = await response.json();
        throw new Error(data.error || 'Failed to add message to thread');
    }
}
// Function to interupt the interface typing process
function stopTyping() {
    isPaused = true;
    const userInputElement = document.getElementById('user-input');
    const sendButton = document.getElementById('send-button');
    sendButton.querySelector('.stop-button').style.display = 'none';
    sendButton.querySelector('i').style.display = 'block';
    sendButton.querySelector('.loader').style.display = 'none';
    sendButton.classList.remove('active');
    userInputElement.disabled = false;
    sendButton.disabled = false;
    isWaitingForResponse = false;
}

// Call this function after the first user question is submitted and displayed
function showNewConversationButton() {
    const newConversationButton = document.getElementById('new-conversation-button');
    if (newConversationButton) {
        newConversationButton.style.display = 'block';
    }
}

function handleKeyPress(event) {
    if (event.key === 'Enter') {
        sendMessage();
    }
}

function toggleChat() {
    document.querySelector('.tooltiptext').style.visibility = 'hidden'
    const chatContainer = document.getElementById('chat-container');
    if (chatContainer.style.display === 'none' || chatContainer.style.display === '') {
        chatContainer.style.display = 'flex';
        document.getElementById('user-input').focus();
        const leftHandle = document.querySelector('.resize-handle.left');
        const bottomHandle = document.querySelector('.resize-handle.bottom');
        
        // Store the initial size and position of the container
        const originalSize = chatContainer.getBoundingClientRect();
        const originalWidth = originalSize.width;
        const originalHeight = originalSize.height;
        
        // Resize speed modifier (lower values make resizing slower)
        const resizeSpeed = 0.3; // Resizing speed (0.3 slows it down to 30% of normal speed)
        
        // Variables to store initial mouse and element positions
        let startX, startY, startWidth, startHeight, startLeft, startTop;
        
        function constrainResize() {
          const rect = chatContainer.getBoundingClientRect();
          const viewportWidth = window.innerWidth;
          const viewportHeight = window.screen.height; // Use window.screen.height for vertical constraints
        
          // Constrain horizontal resizing
          if (rect.left < 0) {
            chatContainer.style.left = '0px';
            chatContainer.style.width = (rect.width + rect.left) + 'px';
          }
          if (rect.right > viewportWidth) {
            chatContainer.style.width = (viewportWidth - rect.left) + 'px';
          }
        
          // Constrain vertical resizing
          if (rect.top < 0) {
            chatContainer.style.top = '0px';
            chatContainer.style.height = (rect.height + rect.top) + 'px';
          }
          if (rect.bottom > viewportHeight) {
            chatContainer.style.height = (viewportHeight - rect.top) + 'px';
          }
        }
        
        // Resizing horizontally (left) with limits and slower resizing
        leftHandle.addEventListener('mousedown', function (e) {
          e.preventDefault();
        
          startX = e.clientX;
          startWidth = chatContainer.offsetWidth;
          startLeft = chatContainer.offsetLeft;
        
          document.addEventListener('mousemove', resizeHorizontally);
          document.addEventListener('mouseup', stopResizing);
        
          function resizeHorizontally(e) {
            const dx = startX - e.clientX;
            let newWidth = startWidth + dx * (resizeSpeed*2);
            let newLeft = startLeft - dx * (resizeSpeed*2);
        
            // Apply the width and left constraints
            if (newWidth >= originalWidth) {
              chatContainer.style.width = newWidth + 'px';
              if (newLeft <= 0) {
                chatContainer.style.left = '0px';
                chatContainer.style.width = (startWidth + startLeft) + 'px';
              } else {
                chatContainer.style.left = newLeft + 'px';
              }
            } else {
              chatContainer.style.width = originalWidth + 'px';
            }
            
            constrainResize();
          }
        
          function stopResizing() {
            document.removeEventListener('mousemove', resizeHorizontally);
            document.removeEventListener('mouseup', stopResizing);
          }
        });
        
        // Resizing vertically (bottom) with limits and slower resizing
        bottomHandle.addEventListener('mousedown', function (e) {
          e.preventDefault();
        
          startY = e.clientY;
          startHeight = chatContainer.offsetHeight;
          startTop = chatContainer.offsetTop;
        
          document.addEventListener('mousemove', resizeVertically);
          document.addEventListener('mouseup', stopResizing);
        
          function resizeVertically(e) {
            const dy = e.clientY - startY;
            let newHeight = startHeight + dy * (resizeSpeed*6);
            let newTop = startTop;
        
            if (newHeight >= originalHeight) {
              if (startTop + newHeight > window.screen.height) {
                newHeight = window.screen.height - startTop;
              }
              chatContainer.style.height = newHeight + 'px';
              if (newTop < 0) {
                chatContainer.style.top = '0px';
                chatContainer.style.height = (startHeight + startTop) + 'px';
              } else {
                chatContainer.style.top = newTop + 'px';
              }
            } else {
              chatContainer.style.height = originalHeight + 'px';
            }
            
            constrainResize();
          }
        
          function stopResizing() {
            document.removeEventListener('mousemove', resizeVertically);
            document.removeEventListener('mouseup', stopResizing);
          }
        });
    } else {
        chatContainer.style.display = 'none';
    }
}


   // Define the assistantId and vectorstore mappings based on the project
   const configMap = {
    "sphinx-ts3d-assistant": {
        assistantId: "asst_a1RgZSeFSBw6wwPzN2pbyWtT",
        vectorstore: {
            staging:"vs_Ea6fBXVL4OHKxtyx4cFG8Byn",
            production:"vs_ui9SNyMWN1H2qmQJukGpsSju"
        }
    },
    "HOOPS Exchange": {
        assistantId: "asst_a1RgZSeFSBw6wwPzN2pbyWtT",
        vectorstore: {
            production:"vs_Ea6fBXVL4OHKxtyx4cFG8Byn",
            staging:"vs_ui9SNyMWN1H2qmQJukGpsSju"
        }
    },
    "HOOPS Publish": {
        assistantId: "asst_YppAVaiTHIGFtHh60jDDD5av",
        vectorstore: {
            production:"vs_3eTt3TPZ29dDXsWuh6bDn62t",
            staging:"vs_mmV0fxQBi7pA6dc8c5aZLNiU"
        }
    },
    "HOOPS Communicator": {
        assistantId: "asst_1MkTnjU8WzzztERYpuY4YG3U",
        vectorstore: {
            staging:"vs_MbxNBeiQjD8OPUa6SZzm8uqp",
            production:"vs_kVvElCt8DWRJT6gUgcIPcuO6"
        }
    },
    "HOOPS Visualize HPS": {
        assistantId: "asst_32Ay3Ut2cGuKHEBhdgDQJTII",
        vectorstore: {
            staging:"vs_JqcLrdtA0jwTrkuty105MEwa",
            production:"vs_Y7UMCLqqZPoudrvEBocdB1LM"
        }
    },
    "HOOPS Visualize 3DF": {
        assistantId: "asst_Bzcm3jSDCBJCcggtSArRTMza",
        vectorstore: {
            staging:"vs_MQUfmP3rq6yBVSoiUNzg2OSM",
            production:"vs_jOlieuQzZrgadbgMOsTrERvk"
        }
    },
    "HOOPS Luminate": {
        assistantId: "asst_PshlEOWECvGwNF6h26tFgEo6",
        vectorstore: {
            staging:"vs_Lzo6rCLZVZOgeh8DPpbYvOh0",
            production:"vs_Na3NFPxbTPEDjemyz7VG0ibn"
        }
    },   
    "CEETRON Envision for Desktop": {
        assistantId: "asst_D614GOxnxQnBQXGiga5ixI3d",
        vectorstore: {
            staging:"vs_2mAlf8IJ2shp0qOtfK2BZx2f",
            production:"vs_Wr9NMvU5H9XZ5QHsTB8UGUtE"
        }
    },
    "CEETRON Envision for Web": {
        assistantId: "asst_PshlEOWECvGwNF6h26tFgEo6",
        vectorstore: {
            staging:"vs_TFDVdHAsbWUaPBwc5UtYxpVO",
            production:"vs_hkGjAvi1E3s2gB6jdZ0nlU4d"
        }
    },    
    "CEETRON Envision for Web": {
        assistantId: "asst_PshlEOWECvGwNF6h26tFgEo6",
        vectorstore: {
            staging:"vs_TFDVdHAsbWUaPBwc5UtYxpVO",
            production:"vs_hkGjAvi1E3s2gB6jdZ0nlU4d"
        }
    },
    "CEETRON Envision for Web": {
        assistantId: "asst_PshlEOWECvGwNF6h26tFgEo6",
        vectorstore: {
            staging:"vs_TFDVdHAsbWUaPBwc5UtYxpVO",
            production:"vs_hkGjAvi1E3s2gB6jdZ0nlU4d"
        }
    },
    "CEETRON Solve/Access/Mesh": {
        assistantId: "asst_iYHRJ5kjfJGlFQniuJC6ieAK",
        vectorstore: {
            staging:"vs_Kuvy2wwwhLSQYs67HIjnQCSs",
            production:"vs_XjDZDMfnr38yMXhSolJxay9i"
        }
    },
    // Add more projects as needed
    // "projectC": { assistantId: "...", vectorstore: "..." }
};

// Retrieve the correct assistantId and vectorstore based on the project
let { assistantId, vectorstore } = {}; 
const model = "gpt-4o-mini";


async function chat(userMessage, threadId) {

    const response = await fetch(`https://swwlbpszod.execute-api.eu-west-3.amazonaws.com/${stage}/SendChat`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            body: JSON.stringify({
                userMessage: userMessage,
                threadId: threadId,
                model: model,
                assistantId: assistantId,
                vectorstore: vectorstore,
                product: chat_project 
            })
        })
    });

    const data = await response.json();
    data.body = JSON.parse(data.body);
    return {
        messages: data.body.messages,
        thread_id: data.body.thread_id,
        refurls: data.body.references,
        file_ids:data.body.file_ids
    };
}

async function fetchHtmlTitle(url) {
    try {
        const response = await fetch(url);
        const text = await response.text();
        const parser = new DOMParser();
        const doc = parser.parseFromString(text, 'text/html');
        const title = doc.querySelector('title').innerText;
        return title;
    } catch (error) {
        console.error('Error fetching HTML title:', error);
        return 'Error fetching title';
    }
}

// After creating or resuming a conversation, store the thread_id
function storeThreadId() {
    const threadData = {
        thread_id: thread_id,
        timestamp: new Date().getTime()
    };
    localStorage.setItem('threadData', JSON.stringify(threadData));
}
