private void _winformsControl_MouseDown(object sender, Winforms.MouseEventArgs e)
{
    var myWindowKey = myCanvas.GetWindowKey();
    var camControl = myWindowKey.GetCameraControl();
    HPS.SegmentKey modelKey = myCanvas.GetAttachedLayout().GetAttachedView().GetAttachedModel().GetSegmentKey();

    myWindowKey.GetSelectionOptionsControl().SetLevel(HPS.Selection.Level.Entity); // choosing entity-level selection
    myWindowKey.GetSelectionOptionsControl().SetProximity(0.01f);
    myWindowKey.GetSelectionOptionsControl().SetAlgorithm(HPS.Selection.Algorithm.Analytic);
    HPS.SprocketPath sprkPath = new HPS.SprocketPath(myCanvas.GetAttachedLayout().GetAttachedView().GetAttachedModel(),myCanvas.GetAttachedLayout().GetAttachedView(),myCanvas.GetAttachedLayout(), myCanvas);
    HPS.KeyPath path = sprkPath.GetKeyPath();

    
    HPS.Point pickStart = new HPS.Point(e.X, e.Y, -1);
    HPS.Point pickEnd = new HPS.Point(e.X, e.Y, 0);
    HPS.Point rayStart = new HPS.Point();

    HPS.Point rayEnd = new HPS.Point();

    path.ConvertCoordinate(HPS.Coordinate.Space.Pixel, pickStart, HPS.Coordinate.Space.World, out rayStart);
    path.ConvertCoordinate(HPS.Coordinate.Space.Pixel, pickEnd, HPS.Coordinate.Space.World, out rayEnd);
    HPS.Vector rayDir = new HPS.Vector(rayEnd - rayStart);
   
    HPS.SelectionResults selectionResults;
    ulong numSelectedItems = myWindowKey.GetSelectionControl().SelectByRay(
        rayStart,
        rayDir,
        myCanvas.GetFrontView().GetSegmentKey(),
        out selectionResults);

    if (numSelectedItems != 0)
    {
       System.Diagnostics.Trace.WriteLine("Hit" + System.Guid.NewGuid().ToString());
    }

    myCanvas.GetWindowKey().GetEventDispatcher().InjectEvent(
    BuildMouseEvent(HPS.MouseEvent.Action.ButtonDown, MapMouseButton(e), e.X, e.Y, true, 0));
}