class BannerComponent extends HTMLElement {
    constructor() {
        super();

        // Attach a shadow root to the element.
        const shadowRoot = this.attachShadow({ mode: 'open' });
        
        //if (isRedirect()) {
            // this is a redirect situation

            // Define the inner structure and styles of the component.
            shadowRoot.innerHTML = `
                <style>

                section {
                  position: absolute;
                  top: 0;
                  left: 0;
                  right: 0;
                  background: var(--ts3d-lt-blue);
                  border-bottom: 1px solid rgba(0, 0, 0, .25);
                  
                  padding: 1ch 2ch;
                  color: #fff;
                  text-align: center;
                  white-space: nowrap;
                  overflow: hidden;
                  text-overflow: ellipsis;

                  i {
                    margin-right: 1ch;
                  }
                }
                </style>
               
                
                <section role="status">
                    <span class="description"></span>
                    <br>Please update your bookmarks.
                </section>
            `;
        //}
    }
    
    connectedCallback() {
        // Update the content when the component is attached to the DOM.
        this.updateContent();
    }

    static get observedAttributes() {
        return ['description'];
    }

    attributeChangedCallback(name, oldValue, newValue) {
        // Update the content when attributes change.
        this.updateContent();
    }

    updateContent() {
        if (this.shadowRoot.querySelector('.description') == null)
            return;
        
        this.shadowRoot.querySelector('.description').textContent = this.getAttribute('description') || '';
    }
}



// Define the new element
customElements.define('banner-component', BannerComponent);
