//Algolia code

const isValidUrl = urlString => {
    try {
        return Boolean(new URL(urlString));
    }
    catch (e) {
        return false;
    }
}
function convertBranchName(branchName) {
    let lastIndex = branchName.lastIndexOf('/');
    if (lastIndex !== -1 && branchName.startsWith('release')) {
        let prefix = branchName.substring(0, lastIndex + 1);
        let suffix = branchName.substring(lastIndex + 1);
        return prefix + suffix.toUpperCase();
    } else {
        return branchName;
    }
}
function SelectSearch() {
    const {hostname} = window.location;

    if (hostname.includes("docs-test") || hostname.includes("docs") || force_algolia_search) {
        
            return true;
        
    } else{
        const node = document.querySelector('#entersearch');
        // Create a new div element
        const div = document.createElement('div');
        div.setAttribute('role', 'search');
        
        // Set the innerHTML of the div element to the provided HTML code
        div.innerHTML = `
        <form id="rtd-search-form" class="wy-form" action="${SearchFilePath}" method="get">
        <input type="text" name="q" placeholder="Search docs" aria-label="Search docs" />
        <input type="hidden" name="check_keywords" value="yes" />
        <input type="hidden" name="area" value="default" />
        </form>
        `;
        if (node) {
                    // Replace the #entersearch element with the new div element
            node.parentNode.replaceChild(div, entersearch);
            console.log("Algolia Search Disabled")
            return false;
        }
    }
}
function findRelativeUrl(url) {
    if (isValidUrl(url)) {
        let domain = new URL(url).hostname;
        const {pathname} = new URL(url);
        if (domain.split('.')[0] == "docs-test") {
            domain = "docs.techsoft3d.com"
        }
        return "https://" + domain + pathname;
    } else {
        if(LogoImagePath != ''){
            return LogoImagePath;
        }
        return url;
    }
}
function MakeUrl(link,highlight) {

    if (isValidUrl(link)) {
        //check that the url starts with http://docs-test.techsoft3d.com or http://docs.techsoft3d.com
        //if it does, then split the url into domain path and tag
        //if it doesn't, then just return the url
        let domain = new URL(link).hostname;
        const {pathname} = new URL(link);
        const tag = new URL(link).hash;

        if (domain.includes("docs-test") || domain.includes("docs")) {
            link = pathname + "?highlight=" + highlight + tag;
        }
        if(branchName !='' && window.location.hostname.includes("docs-test") ){
            branchName = convertBranchName(branchName);
            link = replaceLatest(branchName, link);
            
        }
        //if the current windows pathname contains master  then replace latest in the links with it
        if (window.location.pathname.includes("master")) {
            link = link.replace("latest", "master");
        }

        //If the current window hostname starts with staging.docs.techsoft3d.com then remove /latest from the link
        if (window.location.hostname.startsWith("staging.docs.techsoft3d.com")) {
            link = link.replace("/latest", "");
        }


        if(domain.includes("docs") && project == "HOOPS Visualize 3DF" && release.endsWith("LTS")){
            // Added code to handle all cases with different version numbers
            let pathArray = window.location.pathname.split("/");
            let versionIndex = pathArray.indexOf("3df") + 1;
            let versionNumber = pathArray[versionIndex];
            if (!isNaN(versionNumber) && versionNumber.length > 0) {
                link = link.replace("latest", versionNumber);
            }else if(branchName != ""){
                link = replaceLatest(branchName, link);
            }
        }

        
    }
    return link;

}
function replaceLatest(branchName, link) {
  
      return link.replace("latest", branchName);
   
  }
function hasOneTypeAndOneProduct(str) {
    const typeRegex = /type/g;
    const productRegex = /product/g;
    const typeMatches = str.match(typeRegex);
    const productMatches = str.match(productRegex);
    return typeMatches !== null && typeMatches.length === 1 && productMatches !== null && productMatches.length === 1;
}

function getIndexName() {
    let domain = new URL(window.location.href).hostname;
    let indexName = "UI-TEST"
    //Switch the index name based on the project and the domain
    if (domain.split('.')[0] == "docs") {
        indexName = "Production"
    } else {
        indexName = "Staging"
    }
    
    if (project.toUpperCase() == "HOOPS VISUALIZE 3DF" && release.toUpperCase().endsWith("LTS")){ indexName = "Staging-3DF-27.40"}
    return indexName;
}
window.addEventListener('DOMContentLoaded', e => {
    var isAlgoliaSearch = SelectSearch()
    if(isAlgoliaSearch){
    const { algoliasearch, instantsearch, aa } = window;
    const connectSearchBox = instantsearch.connectors.connectSearchBox;
    const instantSearchRouter = instantsearch.routers.history();
    const { autocomplete , getAlgoliaResults} = window['@algolia/autocomplete-js'];
    const { createLocalStorageRecentSearchesPlugin }  = window['@algolia/autocomplete-plugin-recent-searches'];
    const algoliaClient= algoliasearch('U6867AZUGF', '0f0418c7c80442fc575dcee4cf1ffb28');
    // Mount a virtual search box to manipulate InstantSearch's `query` UI
    // state parameter.
    const searchClient = {
      ...algoliaClient,
      search(requests) {
        
        if (requests.every(({ params , query }) => !params.query && !query)) {
          return Promise.resolve({
            
            results: requests.map(() => ({
              hits: [],
              nbHits: 0,
              nbPages: 0,
              page: 0,
              processingTimeMS: 0,
              hitsPerPage: 0,
              query: '',
              params: '',
            })),
          });
        }
    
        return algoliaClient.search(requests);
      },
    };
    const virtualSearchBox = connectSearchBox(() => {});
    aa('init', {
        appId: 'U6867AZUGF',
        apiKey: 'af938e74ffd98a433765d94f3e4479a0',
    })
    var modal = new tingle.modal({
        footer: true,
        stickyFooter: false,
        closeMethods: ['overlay', 'escape'],
        closeLabel: "Close",
        onClose: function () {
            // Reset body overflow in case mobile filter panel was open
            document.body.style.overflow = '';
        },
        beforeClose: function () {
            // here goes some logic
            // e.g. save content before closing the modal
            return true; // close the modal
        }
    });

    const element = document.getElementById('entersearch');
    const filter = element.getAttribute('class');
    const OpenSearchButton = element.querySelector('.Search-searchbar ');
  // Utility to focus the autocomplete input reliably even if it's not yet in the DOM
  function focusAlgoliaInput(retries = 10) {
    const input = document.querySelector('#searchbox .aa-Input, .aa-Input');
    if (input) {
      try { input.focus(); } catch (e) { /* noop */ }
      return;
    }
    if (retries > 0) {
      setTimeout(() => focusAlgoliaInput(retries - 1), 50);
    }
  }
    OpenSearchButton.addEventListener('click', e => {
        // Check if the event target is not inside the search form
        
            modal.open()
            e.preventDefault();
      // Attempt to focus immediately after opening
      focusAlgoliaInput();
            // searchInput.classList.remove('is-focused');
        
    });
        // Keyboard shortcut listener
        window.addEventListener('keydown', (event) => {
            if (event.ctrlKey && event.key === 'k') {
                modal.open();
        // Defer a tick so modal content is inserted
        setTimeout(() => focusAlgoliaInput(), 10);
              event.preventDefault(); // Prevent the default browser behavior
            }
          });
          modal.setContent(`            
          <div id="searchbox" class=${filter} >

          </div>

          <!-- Horizontal Query Suggestions Slider -->
          <div id="recentsearchPanel" class="query-suggestions-slider"></div>
          
          <div id="searchDiv"> 
                  <div id="current-refinements"></div>
                  
                  <div id="results_filters" class="search-layout">
                      <!-- Mobile filters trigger button -->
                      <button class="mobile-filters-trigger" id="mobile-filters-trigger">
                          Filters
                      </button>
                      
                      <!-- Mobile overlay -->
                      <div class="mobile-filters-overlay" id="mobile-filters-overlay"></div>
                      
                      <div id="searchHelpers" class="search-filters-container">
                          <!-- Mobile close button -->
                          <button class="mobile-filters-close" id="mobile-filters-close">
                              ✕
                          </button>
                          
                          <div id="labelLocation" class="filters-header"><div id="header">Filters</div></div>
                          <div id="hierarchical-menu"></div>
                      </div>
                      <div id="resultsContainer" class="search-results-container">
                                      <div id="language-filters" class="language-filters"></div>
                          <div id="stats" style="display: none"></div>
                          <div id="hits"></div>
                      </div>
                  </div>
          </div>`);          // Add empty state content after modal content is created
          const searchDiv = document.getElementById('searchDiv');
          if (searchDiv && !searchDiv.querySelector('.search-empty-state')) {
            const emptyState = document.createElement('div');
            emptyState.className = 'search-empty-state';
            emptyState.innerHTML = `
              <div class="empty-state-icon">
                <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                  <circle cx="11" cy="11" r="8"></circle>
                  <path d="m21 21-4.35-4.35"></path>
                </svg>
              </div>
              <h3>Search Documentation</h3>
              <p>Start typing to search across all ${project || ''} documentations, tutorials, and guides.</p>
              <div class="search-hints">
                <span>Try searching for:</span>
                <div class="search-examples">
                  <code>installation</code>
                  <code>getting started</code>
                  <code>API reference</code>
                </div>
              </div>
            `;
            searchDiv.appendChild(emptyState);

            // Dedicated no-results state container (initially hidden). We no longer inject this via the stats widget.
            if (!searchDiv.querySelector('.search-no-results-state')) {
              const noResults = document.createElement('div');
              noResults.className = 'search-no-results-state';
              noResults.style.display = 'none';
              noResults.innerHTML = `
                <div class="no-results-message">
                  <div class="no-results-icon">
                    <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                      <circle cx="11" cy="11" r="8"></circle>
                      <path d="m21 21-4.35-4.35"></path>
                      <line x1="9" y1="9" x2="13" y2="13"></line>
                      <line x1="13" y1="9" x2="9" y2="13"></line>
                    </svg>
                  </div>
                  <span class="no-results-text">No results found</span>
                  <span class="no-results-suggestion">Try different keywords or check your spelling</span>
                </div>`;
              searchDiv.appendChild(noResults);
            }
          }
          modal.setFooterContent(`
                <div class="search-footer-shortcuts">
                  <div class="search-footer-shortcut">
                    <span>Navigate</span>
                    <div>
                      <kbd>↑</kbd>
                      <kbd>↓</kbd>
                    </div>
                  </div>
                  <div class="search-footer-shortcut">
                    <span>Select</span>
                    <kbd>Enter</kbd>
                  </div>
                  <div class="search-footer-shortcut">
                    <span>Close</span>
                    <kbd>Esc</kbd>
                  </div> 
                  <div class="search-footer-shortcut">
                    <span>Exact Match</span>
                    <kbd>"."</kbd>
                  </div>
                </div>
              `)
    
    // Add mobile sliding filter panel functionality
    let mobileFiltersInitialized = false;
    const setupMobileFilters = () => {
        try {
            // Check if we're on mobile/tablet first
            if (window.innerWidth > 1024 || mobileFiltersInitialized) return;
            
            const trigger = document.getElementById('mobile-filters-trigger');
            const closeBtn = document.getElementById('mobile-filters-close');
            const overlay = document.getElementById('mobile-filters-overlay');
            const filtersContainer = document.getElementById('searchHelpers');
            
            if (!trigger || !closeBtn || !overlay || !filtersContainer) {
                return;
            }
            
            // Function to open the filters panel
            const openFiltersPanel = (e) => {
                try {
                    if (e) e.preventDefault();
                    filtersContainer.classList.add('panel-open');
                    overlay.classList.add('active');
                    document.body.style.overflow = 'hidden';
                } catch (error) {
                    
                }
            };
            
            // Function to close the filters panel
            const closeFiltersPanel = (e) => {
                try {
                    if (e) e.preventDefault();
                    filtersContainer.classList.remove('panel-open');
                    overlay.classList.remove('active');
                    document.body.style.overflow = '';
                } catch (error) {
                    
                }
            };
            
            // Add event listeners
            trigger.addEventListener('click', openFiltersPanel);
            closeBtn.addEventListener('click', closeFiltersPanel);
            overlay.addEventListener('click', closeFiltersPanel);
            
            // Close panel when a filter is selected (for better mobile UX)
            const hierarchicalMenu = document.getElementById('hierarchical-menu');
            if (hierarchicalMenu) {
                hierarchicalMenu.addEventListener('click', (e) => {
                    try {
                        // Check if a filter link was clicked
                        if (e && e.target && e.target.closest('a')) {
                            // Add small delay to allow the filter to be applied first
                            setTimeout(() => {
                                closeFiltersPanel();
                            }, 200);
                        }
                    } catch (error) {
                      
                    }
                });
            }
            
            // Handle escape key
            const handleEscape = (e) => {
                try {
                    if (e && e.key === 'Escape' && filtersContainer.classList.contains('panel-open')) {
                        closeFiltersPanel(e);
                    }
                } catch (error) {
                    
                }
            };
            
            document.addEventListener('keydown', handleEscape);
            
            mobileFiltersInitialized = true;
            
        } catch (error) {
            
        }
    };
    
    // Setup mobile filters after modal opens
    modal.onOpen = function() {
        const autocompleteInput = document.getElementsByClassName("aa-Input");
        if (autocompleteInput.item(0) != null) {
            autocompleteInput[0].focus();
        }
  // Fallback in case the input was not present yet at onOpen
  focusAlgoliaInput();
        
        // Mobile filters will be set up by the search.on('render') callback
        // This ensures they're ready after the widgets are initialized
    };
   
    const insightsMiddleware = instantsearch.middlewares.createInsightsMiddleware({
        insightsClient: aa,
    })

    var du = new DeviceUUID().parse();
    var dua = [
        du.language,
        du.platform,
        du.os,
        du.cpuCores,
        du.isAuthoritative,
        du.silkAccelerated,
        du.isKindleFire,
        du.isDesktop,
        du.isMobile,
        du.isTablet,
        du.isWindows,
        du.isLinux,
        du.isLinux64,
        du.isMac,
        du.isiPad,
        du.isiPhone,
        du.isiPod,
        du.isSmartTV,
        du.pixelDepth,
        du.isTouchScreen
    ];
    var uuid = du.hashMD5(dua.join(':'));
    aa("setUserToken", uuid)
    let currentIndex = -1;
  let hasSearchedOnce = false; // Track if user has searched at least once
  // Track pending focus after auto-loading next page via keyboard
  let pendingFocusAfterLoad = null; // 'nextPage' | null
  let prevItemCountForFocus = 0;

    const search = instantsearch({
        indexName: getIndexName(),
        searchClient,
        searchFunction(helper) {
            currentIndex = -1;
            const searchDiv = document.querySelector('#searchDiv');
            const container = document.querySelector('#hits');
            const emptyState = document.querySelector('.search-empty-state');
            
            // Add/remove has-query class to control CSS visibility
            const hasQuery = helper.state.query !== '';
            if (searchDiv) {
                if (hasQuery) {
                    searchDiv.classList.add('has-query');
                    hasSearchedOnce = true; // Mark that user has searched
                } else {
                    searchDiv.classList.remove('has-query');
                }
            }
            
            // Check if there's an initial query from URL/routing
            if (hasQuery && !hasSearchedOnce) {
                hasSearchedOnce = true;
            }
            
            // Always keep hits container visible so search results can be displayed
            if (container) {
                container.style.display = 'block';
            }
            
            // Handle empty state visibility
            if (emptyState) {
                if (hasQuery || hasSearchedOnce) {
                    emptyState.style.display = 'none';
                } else {
                    emptyState.style.display = 'block';
                }
            }
            
            helper.search();
        },
        routing: instantSearchRouter, //Uncomment for proper URL routing for Autocomplete
    });



    search.use(insightsMiddleware)
    const sessionStorageCache = instantsearch.createInfiniteHitsSessionStorageCache();

    search.addWidgets([
        virtualSearchBox({}), //Uncomment this to Enable Autocomplete Search box
        instantsearch.widgets.configure({
            filters: filter,
            hitsPerPage: 20,
            facetingAfterDistinct: true,
            analyticsTags: [project],
        }),
        instantsearch.widgets.infiniteHits({
            container: '#hits',
            cache: sessionStorageCache,
            templates: {
                item(hit, bindEvent) {
                    let lang = hit && hit["locations.lvl1"] ? hit["locations.lvl1"].split(" > ")[1] : ''
                    switch (lang) {
                        case "cpp": lang = 'C++'; break;
                        case "cs": lang = 'C#'; break;
                        case '': lang = ''; break;
                    }
                    const langDiv = lang ? `<div class="hit-price" style="float:right">${lang}</div>` : '';
                    const location = hit.location ? `<div class="hit-location" style="float: left;">${substituteProductName(hit.location)}</div>` : '';
                    var type = hit.type ? `<div class="hit-location" style="float: left;">${hit.type}</div>` : '';
                    if(hit.type == "video") type = `<div class="hit-location video-tag" style="float: left;">Youtube video</div>`
                    var style = ""
                    switch (hit.product) {
                        case "HOOPS Communicator": style = "hc"; break;
                        case "HOOPS Exchange": style = "he"; break;
                        case "HOOPS Publish": style = "hp"; break;
                        case "HOOPS Visualize 3DF": style = "hv"; break;
                        case "HOOPS Visualize Desktop": style = "hv"; break;
                        case "HOOPS Demo Viewer": style = "hnp"; break;
                        case "HOOPS Parasolid Demo Viewer": style = "hnp"; break;
                        case "CEETRON Solve/Access/Mesh": style = "ceesam"; break;
                        case "CEETRON Envision for Web": style = "ceetron"; break;
                        case "CEETRON Envision for Desktop":style = "ceetron"; break;
                        case "HOOPS Luminate": style = "hl"; break;
                        case "SpinFire Manage":style = "spinfire"; break;
                    }
                    const searchbox = document.getElementById('searchbox');
                    const searchInput = searchbox.querySelector('input[class="aa-Input"]');
                    const displayProductName = substituteProductName(hit.product);
                    const product = hit.product ? `<div class="hit-product ${style}" style="float: left;">${displayProductName}</div>` : '';
                    return `
  <a href='${MakeUrl(hit.url, searchInput.value)}'
    ${bindEvent('click', hit, 'Search Result Clicked')}
  >
    <div class="hit-name">
      ${instantsearch.highlight({ "attribute": "title", hit })}
    </div>
    <div class="hit-description">
      ${instantsearch.snippet({ "attribute": "body", hit })}
    </div>
    <div style="display:inline">
    ${product}
    ${type}
    ${location}
    ${langDiv}
    </div>
  </div>
`
                },
            },
        }),
        instantsearch.widgets.stats({
            container: '#stats',
            templates: {
                text(data, { html }) {
          // We intentionally render nothing here; stats container kept minimal for layout consistency (hidden via CSS).
          return html``;
                },
            },
        }),
  // Removed hitsPerPage control to rely solely on infinite scroll
    ]);
// // Keyboard navigation event listener using event delegation
    if (hasOneTypeAndOneProduct(filter)) {

        if (project == "HOOPS Visualize Desktop") {
            search.addWidgets([
                instantsearch.widgets.hierarchicalMenu({
                    container: '#hierarchical-menu',
                    attributes: [
                        'locations.lvl0',
                        'locations.lvl1',
                    ],
                    cssClasses: {
                        childList: ['MyCustomCssChild']
                    },
                    sortBy(a, b) {
                        // Define a consistent order array to maintain stable positioning
                        const order = [
                            "Getting Started",
                            "Programming Guide", 
                            "API Reference",
                            "API REFERENCES",
                            "Additional Resources",
                            "COMMON",
                            "DOCUMENTATION",
                            "KNOWLEDGE BASE",
                            "COMMUNITY"
                        ];
                        
                        const aIndex = order.indexOf(a.name);
                        const bIndex = order.indexOf(b.name);
                        
                        // If both items are in the order array, sort by their position
                        if (aIndex !== -1 && bIndex !== -1) {
                            return aIndex - bIndex;
                        }
                        
                        // If only a is in the order array, it comes first
                        if (aIndex !== -1) return -1;
                        
                        // If only b is in the order array, it comes first
                        if (bIndex !== -1) return 1;
                        
                        // If neither is in the order array, sort alphabetically
                        return a.name.localeCompare(b.name);
                    },
                    templates: {
                        item(data, { html }) {
                            let { label, count, url, cssClasses } = data;
                            
                            // Apply product name substitution to labels
                            label = substituteProductName(label);
                            
                            cssClasses.count = "ais-HitsCount"
                            if (label === "cpp") { label = "C++"; cssClasses.link = "ais-CustomMenu-item"; cssClasses.label = "ais-CustomMenu-label"; cssClasses.count = "ais-CustomMenu-count"}
                            if (label === "cs") { label = "C#"; cssClasses.link = "ais-CustomMenu-item1"; cssClasses.label = "ais-CustomMenu-label";cssClasses.count = "ais-CustomMenu-count" }
                            
                            return html`
                                        <a class="${cssClasses.link}" href="${url}">
                                    
                                        <span class="${cssClasses.label}" >${label}</span>
                                        <span class="${cssClasses.count}">${count}</span>
                                        </a>
                                    `;
                    },
                    },
                }),])

        } else {
            search.addWidgets([
                instantsearch.widgets.menu({
                    container: '#hierarchical-menu',
                    attribute: 'location',
                    sortBy(a, b) {
                        // Define a consistent order array to maintain stable positioning
                        const order = [
                            "Getting Started",
                            "Tutorials",
                            "Programming Guide",
                            "API References",
                            "DOCUMENTATION",
                            "KNOWLEDGE BASE",
                            "COMMUNITY"
                        ];
                        
                        const aIndex = order.indexOf(a.name);
                        const bIndex = order.indexOf(b.name);
                        
                        // If both items are in the order array, sort by their position
                        if (aIndex !== -1 && bIndex !== -1) {
                            return aIndex - bIndex;
                        }
                        
                        // If only a is in the order array, it comes first
                        if (aIndex !== -1) return -1;
                        
                        // If only b is in the order array, it comes first
                        if (bIndex !== -1) return 1;
                        
                        // If neither is in the order array, sort alphabetically
                        return a.name.localeCompare(b.name);
                    },
                    templates: {
                        item(data, { html }) {
                            const { label, count, url, cssClasses } = data;
                            
                            // Apply product name substitution to labels
                            const displayLabel = substituteProductName(label);

                            return html`
                    <a class="${cssClasses.link}" href="${url}">

                      <span class="${cssClasses.label}">${displayLabel}</span>
                      <span class="ais-HitsCount">${count}</span>
                    </a>
                  `;
                        },
                    },
                    transformItems(items) {
                        // Add hits count to each item
                        return items.map(item => {
                          const { count, ...rest } = item;
                          return {
                            count,
                            ...rest,
                          };
                        });
                    }
                }),
            ])
        }
    } else {

        search.addWidgets([
            instantsearch.widgets.hierarchicalMenu({
                container: '#hierarchical-menu',
                attributes: [
                    'categories.lvl0',
                    'categories.lvl1',
                    'categories.lvl2',
                    'categories.lvl3',
                ],maxValuesPerFacet: {
                    'categories.lvl0': 10000,
                    'categories.lvl1': 10000,
                    'categories.lvl2': 10000,
                    'categories.lvl3': 10000,
                },
                cssClasses: {
                    childList: ['MyCustomCssChild']
                },
                sortBy(a, b) {
                    // Define a consistent order array to maintain stable positioning
                    const order = [
                        "Getting Started",
                        "GETTING STARTED",
                        "Sample Code",
                        "Programming Guide",
                        "API References",
                        "API REFERENCES", 
                        "Additional Resources",
                        "Envision Frameworks",
                        "COMMON",
                        "CEETRON SOLVE",
                        "CEETRON ACCESS", 
                        "CEETRON MESH",
                        "Legacy Visualization",
                        "DOCUMENTATION",
                        "KNOWLEDGE BASE",
                        "COMMUNITY"
                    ];
                    
                    const aIndex = order.indexOf(a.name);
                    const bIndex = order.indexOf(b.name);
                    
                    // If both items are in the order array, sort by their position
                    if (aIndex !== -1 && bIndex !== -1) {
                        return aIndex - bIndex;
                    }
                    
                    // If only a is in the order array, it comes first
                    if (aIndex !== -1) return -1;
                    
                    // If only b is in the order array, it comes first
                    if (bIndex !== -1) return 1;
                    
                    // If neither is in the order array, sort alphabetically
                    return a.name.localeCompare(b.name);
                },
                templates: {
                    item(data, { html }) {
                        let { label, count, url, cssClasses } = data;
                        var rootCount = 0
                        if(label == "DOCUMENTATION" && data.data){ 
                            
                            data.data.forEach(element => {
                                rootCount = rootCount + element.count 
                            });
                            if(rootCount > count){
                                count = rootCount
                            }
                        }
                        
                        // Apply product name substitution to labels
                        label = substituteProductName(label);
                        
                        cssClasses.count = "ais-HitsCount"
                        if (label === "cpp") { label = "C++"; cssClasses.link = "ais-CustomMenu-item"; cssClasses.label = "ais-CustomMenu-label"; cssClasses.count = "ais-CustomMenu-count"}
                        if (label === "cs") { label = "C#"; cssClasses.link = "ais-CustomMenu-item1"; cssClasses.label = "ais-CustomMenu-label";cssClasses.count = "ais-CustomMenu-count" }
                        
                        return html`
                    <a class="${cssClasses.link}" href="${url}">
                  
                      <span class="${cssClasses.label}" >${label}</span>
                      <span class="${cssClasses.count}">${count}</span>
                    </a>
                  `;
                    },
                },
                transformItems(items) {
                    // Add hits count to each item
                    return items.map(item => {
                      const { count, ...rest } = item;
                      return {
                        count,
                        ...rest,
                      };
                    });
                }
            }),
            instantsearch.widgets.currentRefinements({
                container: '#current-refinements',
                transformItems(items) {
                    if (items[0]) items[0].label = "Location"
                    return items
                },
            }),
        ])
    }
    search.on('render', () => {
      // --- No-results debounce state ---
      // If results temporarily show 0 hits during initial fetch, we wait a short debounce before displaying no-results UI.
      // This avoids flicker while Algolia returns first page.
      if (typeof window.__noResultsVarsInitialized === 'undefined') {
        window.__noResultsVarsInitialized = true;
        window.__noResultsPendingTimer = null; // active timeout id
        window.__showNoResultsConfirmed = false; // only true after debounce period with still zero hits
        window.__lastQueryForNoResults = '';
      }
      const resetButton = document.querySelector('.aa-ClearButton');
      const emptyState = document.querySelector('.search-empty-state');
      const noResultsState = document.querySelector('.search-no-results-state');
      const hits = document.querySelectorAll('#hits .ais-InfiniteHits-item');
      const query = search.helper.state.query;
      const queryLength = query ? query.length : 0;
      const searchBoxContainer = document.getElementById('searchbox');
      const hierarchicalMenuEl = document.querySelector('#hierarchical-menu');
      const headerEl = document.querySelector('#header');
      const searchHelpersEl = document.querySelector('#searchHelpers');
      const hitsContainerEl = document.querySelector('#hits');
      const resultsFiltersEl = document.querySelector('#results_filters');

      // Debounced no-results detection
      const lastResults = search.helper.lastResults;
      const zeroHitsNow = Boolean(lastResults) && lastResults.nbHits === 0 && queryLength >= 3;

      // Helper to apply UI states (defined inline to reference current scoped vars)
      const applyNoResultsUI = (active) => {
        const currentRefinementsEl = document.querySelector('#current-refinements');
        if (active) {
          if (hierarchicalMenuEl) hierarchicalMenuEl.style.display = 'none';
          if (headerEl) headerEl.style.display = 'none';
          if (searchHelpersEl) searchHelpersEl.style.setProperty('display', 'none', 'important');
          if (hitsContainerEl) hitsContainerEl.style.setProperty('display', 'none', 'important');
          if (currentRefinementsEl) currentRefinementsEl.style.setProperty('display', 'none', 'important');
          if (resultsFiltersEl) {
            resultsFiltersEl.style.setProperty('display', 'none', 'important');
            resultsFiltersEl.style.removeProperty('justify-content');
          }
          if (emptyState) emptyState.style.display = 'none';
          if (noResultsState) noResultsState.style.display = 'block';
          // Keep query suggestions panel visible if it exists (we're asked to keep last suggestions)
          const suggestionsContainer = document.querySelector('.query-suggestions-horizontal');
          if (suggestionsContainer) suggestionsContainer.style.display = 'block';
        } else {
          if (noResultsState) noResultsState.style.display = 'none';
          if (resultsFiltersEl) {
            resultsFiltersEl.style.removeProperty('display');
            resultsFiltersEl.style.justifyContent = 'space-between';
          }
          if (currentRefinementsEl) currentRefinementsEl.style.removeProperty('display');
          if (hierarchicalMenuEl) hierarchicalMenuEl.style.display = '';
          if (headerEl) headerEl.style.display = '';
          if (searchHelpersEl) searchHelpersEl.style.display = '';
          if (hitsContainerEl) hitsContainerEl.style.removeProperty('display');
        }
      };

      // If we have zero hits, immediately hide filters & schedule confirmation; else cancel
      if (zeroHitsNow) {
        // Proactively hide filters while waiting for debounce to avoid flash
        if (resultsFiltersEl) resultsFiltersEl.style.setProperty('display','none','important');
        if (hitsContainerEl) hitsContainerEl.style.setProperty('display','none','important');
        // If new query or not already confirmed, set pending
        if (window.__lastQueryForNoResults !== query) {
          window.__showNoResultsConfirmed = false;
        }
        window.__lastQueryForNoResults = query;
        if (!window.__showNoResultsConfirmed) {
          if (window.__noResultsPendingTimer) clearTimeout(window.__noResultsPendingTimer);
          window.__noResultsPendingTimer = setTimeout(() => {
            // Re-check still zero hits & same query before confirming
            const reLast = search.helper.lastResults;
            const stillZero = Boolean(reLast) && reLast.nbHits === 0 && search.helper.state.query === window.__lastQueryForNoResults;
            if (stillZero) {
              window.__showNoResultsConfirmed = true;
              applyNoResultsUI(true);
            }
          }, 200); // 200ms debounce threshold
        } else {
          // Already confirmed
          applyNoResultsUI(true);
        }
      } else {
        // Any hits or query shortened resets no-results state
        if (window.__noResultsPendingTimer) {
          clearTimeout(window.__noResultsPendingTimer);
          window.__noResultsPendingTimer = null;
        }
        if (window.__showNoResultsConfirmed) {
          window.__showNoResultsConfirmed = false;
        }
        applyNoResultsUI(false);
      }
      
      // Handle search state and UI visibility
      if (queryLength >= 3) {
        hasSearchedOnce = true;
        if (searchBoxContainer) searchBoxContainer.classList.add('has-query');
        // Hide empty state unless we end up in confirmed no-results later
        if (emptyState && !window.__showNoResultsConfirmed) emptyState.style.display = 'none';
        // No special suggestions retention logic anymore; suggestions container hidden when searching
        const suggestionsContainer = document.querySelector('.query-suggestions-horizontal');
        if (suggestionsContainer) suggestionsContainer.style.display = 'none';
      } else {
        if (searchBoxContainer) searchBoxContainer.classList.remove('has-query');
        // Show empty state when there's no query (whether first time or after clearing)
        if (emptyState && queryLength === 0) {
          emptyState.style.display = 'block';
        } else if (emptyState) {
          emptyState.style.display = 'none';
        }
        // Hide suggestions when not actively searching (removed behavior)
        const suggestionsContainer = document.querySelector('.query-suggestions-horizontal');
        if (suggestionsContainer) suggestionsContainer.style.display = 'none';
      }
      
      // Disable keyboard navigation for query suggestions
      const querySuggestionItems = document.querySelectorAll('#recentsearchPanel .aa-Item');
      querySuggestionItems.forEach(item => {
        item.setAttribute('tabindex', '-1');
        item.style.pointerEvents = 'auto'; // Allow mouse clicks but disable keyboard focus
      });
      
  // Do not tamper with autocomplete's internal listeners; removing this avoids runtime errors
      if (resetButton) {
        resetButton.className = "ais-SearchBox-reset";
        resetButton.addEventListener('click', () => {
          hasSearchedOnce = false; // Reset search flag on clear
          search.helper.setQuery('');
          search.helper.clearRefinements();
          search.helper.search();
          
          // Update UI state immediately after reset
          const searchBoxContainer = document.getElementById('searchbox');
          if (searchBoxContainer) searchBoxContainer.classList.remove('has-query');
          if (emptyState) emptyState.style.display = 'block';
        });
      }

      // If we requested the next page via keyboard, focus the first newly loaded item
      if (pendingFocusAfterLoad === 'nextPage') {
        const items = Array.from(document.querySelectorAll('#hits .ais-InfiniteHits-item'));
        if (items.length > prevItemCountForFocus) {
          const newIndex = prevItemCountForFocus; // first new item
          setFocus(newIndex, items);
          pendingFocusAfterLoad = null;
        }
      }
      // Keep currentIndex within bounds if list changed
      const total = hits.length;
      if (total > 0) {
        if (currentIndex >= total) currentIndex = total - 1;
        if (currentIndex < -1) currentIndex = -1;
      }

      // Populate / refresh language filters (C++ / C#) above results
      try {
        const langContainer = document.getElementById('language-filters');
        if (langContainer) {
          // Rebuild every render to keep selection state in sync
          langContainer.innerHTML = '';
          const langLinks = document.querySelectorAll('#hierarchical-menu .ais-CustomMenu-item, #hierarchical-menu .ais-CustomMenu-item1');
          langLinks.forEach(link => {
            const clone = link.cloneNode(true);
            clone.classList.add('language-filter-link');
            // Active state detection (selected ancestor li)
            const li = link.closest('li');
            if (li && li.classList.contains('ais-HierarchicalMenu-item--selected')) {
              clone.classList.add('active');
              clone.setAttribute('aria-current', 'page');
            }
            // Ensure click triggers original behavior without full reload (if InstantSearch routing active)
            clone.addEventListener('click', (e) => {
              // Let modifier clicks behave normally
              if (e.metaKey || e.ctrlKey || e.altKey || e.shiftKey || e.button === 1) return;
              e.preventDefault();
              // Trigger original link click (it contains correct href for refinement/routing)
              link.click();
            });
            langContainer.appendChild(clone);
          });
          if (langLinks.length === 0) {
            langContainer.style.display = 'none';
          } else {
            langContainer.style.display = 'flex';
          }
        }
      } catch (err) {
        
      }
    });
    search.start();
    
    // Setup mobile filters after search starts and widgets are ready
    search.on('render', () => {
        if (window.innerWidth <= 1024) {
            // Wait for the DOM to be updated after render
            setTimeout(() => {
                const trigger = document.getElementById('mobile-filters-trigger');
                const hierarchicalMenu = document.getElementById('hierarchical-menu');
                if (trigger && hierarchicalMenu) {
                    setupMobileFilters();
                }
            }, 50);
        }
    });
    
    // Auto-load more results on scroll (infinite scrolling)
    const hitsContainer = document.getElementById('hits');
    if (hitsContainer) {
      let loading = false;
      let debounceId = null;
      // Helper to clear keyboard-focused state when user uses the mouse
      const clearKeyboardFocus = () => {
        const focused = document.querySelectorAll('#hits .ais-InfiniteHits-item.focused');
        focused.forEach(item => {
          item.classList.remove('focused');
          item.setAttribute('aria-selected', 'false');
          item.setAttribute('tabindex', '-1');
        });
        currentIndex = -1;
      };
      const triggerLoadMoreIfNeeded = () => {
        if (loading) return;
        const list = hitsContainer.querySelector('.ais-InfiniteHits-list');
        if (!list) return;
        const nearBottom = (list.scrollTop + list.clientHeight) >= (list.scrollHeight - 40);
        if (nearBottom) {
          const loadMoreBtn = document.querySelector('.ais-InfiniteHits-loadMore button');
          if (loadMoreBtn && !loadMoreBtn.disabled) {
            loading = true;
            loadMoreBtn.click();
            setTimeout(() => { loading = false; }, 300);
          } else {
            // Fallback: use helper to advance page
            const helper = search.helper;
            if (helper && helper.state.page + 1 < helper.lastResults?.nbPages) {
              loading = true;
              helper.nextPage().search();
              setTimeout(() => { loading = false; }, 300);
            }
          }
        }
      };
      const onScroll = () => {
        if (debounceId) clearTimeout(debounceId);
        debounceId = setTimeout(triggerLoadMoreIfNeeded, 50);
      };
      const bindToList = () => {
        const listEl = hitsContainer.querySelector('.ais-InfiniteHits-list');
        if (listEl && !listEl._infiniteScrollBound) {
          listEl.addEventListener('scroll', onScroll);
          listEl._infiniteScrollBound = true;
        }
        // Bind mouse interactions once to clear keyboard focus when using the mouse
        if (listEl && !listEl._mouseHandlersBound) {
          listEl.addEventListener('mouseover', (e) => {
            if (e.target.closest('.ais-InfiniteHits-item')) {
              clearKeyboardFocus();
            }
          });
          listEl.addEventListener('mousedown', (e) => {
            if (e.target.closest('.ais-InfiniteHits-item')) {
              clearKeyboardFocus();
            }
          });
          listEl._mouseHandlersBound = true;
        }
      };
      bindToList();
      // Rebind after renders in case the list element is re-created
      search.on('render', () => {
        bindToList();
        // Preload if content shorter than viewport
        setTimeout(triggerLoadMoreIfNeeded, 0);
      });
    }
//Navigation for keyboard (hits only)
    document.addEventListener('keydown', event => {
      if (modal.isOpen() && document.querySelector('#hits .ais-InfiniteHits-list')) {
          const resultItems = document.querySelectorAll('#hits .ais-InfiniteHits-item');
          const canLoadMore = () => {
            const helper = search.helper;
            const last = helper?.lastResults;
            return Boolean(last) && (helper.state.page + 1) < last.nbPages;
          };
          const requestNextPage = () => {
            // Try button first, then helper fallback
            const btn = document.querySelector('#hits .ais-InfiniteHits-loadMore button');
            if (btn && !btn.disabled) {
              btn.click();
            } else if (search.helper?.lastResults && (search.helper.state.page + 1) < search.helper.lastResults.nbPages) {
              search.helper.nextPage().search();
            }
          };
    
          switch (event.key) {
              case 'ArrowUp':
                  event.preventDefault();
                  setFocus(currentIndex - 1, resultItems);
                  break;
              case 'ArrowDown':
                  event.preventDefault();
                  const atEnd = currentIndex + 1 >= resultItems.length;
                  if (atEnd) {
                    if (canLoadMore()) {
                      // Defer focus to the first newly loaded item once data arrives
                      pendingFocusAfterLoad = 'nextPage';
                      prevItemCountForFocus = resultItems.length;
                      requestNextPage();
                      // Nudge scroll to bottom to ensure load is triggered
                      const list = document.querySelector('#hits .ais-InfiniteHits-list');
                      if (list) list.scrollTop = list.scrollHeight;
                      // Do NOT wrap now; wait for render hook to focus first of new items
                    } else {
                      // No more pages; wrap to first
                      setFocus(0, resultItems);
                    }
                  } else {
                    setFocus(currentIndex + 1, resultItems);
                  }
                  break;
              case 'Enter':
                  event.preventDefault();
                  if (currentIndex >= 0 && currentIndex < resultItems.length) {
                      const focusedItem = resultItems[currentIndex];
                      // Navigate to the result link
                      const link = focusedItem.querySelector('a');
                      if (link) link.click();
                  }
                  break;
          }
      }
    });
    
    // Function to set focus on a result item
    function setFocus(index, resultItems) {
        if (!resultItems || resultItems.length === 0) {
          currentIndex = -1;
          return;
        }
        if (index < 0) {
            index = resultItems.length - 1;
        } else if (index >= resultItems.length) {
            index = 0;
        }
    
        resultItems.forEach(item => {
          item.classList.remove('focused');
          item.setAttribute('aria-selected', 'false');
          // Ensure items can receive focus programmatically
          item.setAttribute('tabindex', '-1');
        });
        resultItems[index].classList.add('focused');
        resultItems[index].setAttribute('aria-selected', 'true'); // Remove the tabindex from the previous focused result item
        resultItems[index].setAttribute('tabindex', '0');
        resultItems[index].focus();
    
        currentIndex = index; // Remember the current index
        // Scroll the focused result item into view
        resultItems[index].scrollIntoView({ behavior: 'smooth', block: 'center' });
    }

    ///Autocomplete Integration starts here : WIP

//     // Set the InstantSearch index UI state from external events.
function setInstantSearchUiState(indexUiState) {
  
    search.setUiState(uiState => ({
      ...uiState,
      [getIndexName()]: {
        ...uiState[getIndexName()],
        // We reset the page when the search state changes.
        page: 1,
        ...indexUiState,
      },
    }));
    
  }
//   // Return the InstantSearch index UI state.
function getInstantSearchUiState() {
    const uiState = instantSearchRouter.read();
    if(uiState && uiState[getIndexName()]) modal.open()
    return (uiState && uiState[getIndexName()]) || {};
  }
  const searchPageState = getInstantSearchUiState();

let skipInstantSearchUiStateUpdate = false;

//   // This keeps Autocomplete aware of state changes coming from routing
// // and updates its query accordingly
window.addEventListener('popstate', () => {
    skipInstantSearchUiStateUpdate = true;
    setQuery(search.helper?.state.query || '');
    
  });
//   // Build URLs that InstantSearch understands.
function getInstantSearchUrl(indexUiState) {
    return search.createURL({ [getIndexName()]: indexUiState });
  }
//   // Detect when an event is modified with a special key to let the browser
// // trigger its default behavior.
function isModifierEvent(event) {
    const isMiddleClick = event.button === 1;
  
    return (
      isMiddleClick ||
      event.altKey ||
      event.ctrlKey ||
      event.metaKey ||
      event.shiftKey
    );
  }
  function onSelect({ setIsOpen, setQuery, event, query }) {
    // You want to trigger the default browser behavior if the event is modified.
    if (isModifierEvent(event)) {
      return;
    }
    setQuery(query);
    setIsOpen(false);
    setInstantSearchUiState({ query });
  }
  
  function getItemUrl({ query }) {
    return getInstantSearchUrl({ query });
  }
  
  function createItemWrapperTemplate({ children, query, html }) {
    const uiState = { query };
   
    return html`<a
      class="aa-ItemLink"
      href="${getInstantSearchUrl(uiState)}"
      onClick="${(event) => {
        if (!isModifierEvent(event)) {
          // Bypass the original link behavior if there's no event modifier
          // to set the InstantSearch UI state without reloading the page.
          event.preventDefault();
        }
      }}"
    ><div class="aa-Hit-container">
      ${children}
      </div>
    </a>`;
  }
 const querySuggestionsPlugin = createQuerySuggestionsPlugin({
  searchClient,
  indexName: 'Production_query_suggestions',
  transformSource({ source }) {
    return {
      ...source,
      getItemUrl({ item }) {
        return getItemUrl({
          query: item.query,
        });
      },
      onSelect({ setIsOpen, setQuery, item, event }) {
        //clear filters when selecting another query
        search.helper.clearRefinements();
        onSelect({
          setQuery,
          setIsOpen,
          event,
          query: item.query,
        });
      },
      // Update the default `item` template to wrap it with a link
      // and plug it to the InstantSearch router.
      templates: {
        ...source.templates,
        item(params) {
          const { children } = source.templates.item(params).props;
          search.helper.clearRefinements();
          return createItemWrapperTemplate({
            query: params.item.query,
            children,
            html: params.html,
          });
        },
      },
    };
  },

});

 const type = extractTypeAndProduct(filter).type
  const product = extractTypeAndProduct(filter).product
  // Product name now injected directly in initial empty state HTML

  // Make example <code> tags clickable to populate the search query
  try {
    const exampleCodes = document.querySelectorAll('.search-examples code');
    exampleCodes.forEach(codeEl => {
      codeEl.style.cursor = 'pointer';
      if (!codeEl._exampleClickBound) {
        codeEl.addEventListener('click', () => {
          const q = codeEl.textContent.trim();
          if (!q) return;
          // Set autocomplete input value if present
          const input = document.querySelector('#searchbox .aa-Input');
          if (input) {
            input.value = q;
            input.dispatchEvent(new Event('input', { bubbles: true }));
            input.focus();
          }
          // Update InstantSearch helper directly to trigger search
            try { search.helper.setQuery(q).search(); } catch(err) { /* ignore */ }
        });
        codeEl._exampleClickBound = true;
      }
    });
  } catch(e) { /* silent */ }
  const { setQuery } = autocomplete({
    container: '#searchbox',
    placeholder: 'Tap To Search',
    panelContainer: '#recentsearchPanel',
    detachedMediaQuery: 'none',  // You want recent searches to appear with an empty query.
    //openOnFocus: true,
  // Keep panel open when input loses focus so query suggestions remain visible
  debug: true,
  openOnFocus: true,
    autoFocus: true,
    insights: true,
    classNames:{
      item:'ais-InfiniteHits-item query-suggestion-item',
      panel: 'query-suggestions-panel',
      list: 'query-suggestions-list',
    },
    // Add the recent searches plugin.
    //plugins: [recentSearchesPlugin],  
    //plugins: [querySuggestionsPlugin],
    initialState: {
      query: searchPageState.query || '',
    },
    onSubmit({ state }) {
      setInstantSearchUiState({ query: state.query });
    },
    onReset() {
      
      currentIndex = -1;
      hasSearchedOnce = false; // Reset the search flag
      search.helper.clearRefinements();
      setInstantSearchUiState({ query: '' });
      
      // Show empty state again when form is cleared
      const emptyState = document.querySelector('.search-empty-state');
      if (emptyState) {
        emptyState.style.display = 'block';
      }
    },
    onStateChange({ prevState, state }) {
      
      search.helper.clearRefinements();
      
      // Always keep query suggestions visible - they will only be hidden when input is completely cleared
      const suggestionsPanel = document.getElementById('recentsearchPanel');
      if (suggestionsPanel) {
        suggestionsPanel.style.display = 'block';
      }
      
      if (state.query.length < 3 && state.query.length > 0) {
          return; // no search if less than X characters
        }

        // Removed typed queries caching logic
        
        if (!skipInstantSearchUiStateUpdate && prevState.query !== state.query) {
          // When both suggestions and hits exist, ensure focus starts at the first hit
          const firstHit = document.querySelector('#hits .ais-InfiniteHits-item');
          if (firstHit) {
            firstHit.scrollIntoView({ behavior: 'smooth', block: 'center' });
            const allHits = Array.from(document.querySelectorAll('#hits .ais-InfiniteHits-item'));
            const idx = allHits.indexOf(firstHit);
            currentIndex = idx >= 0 ? idx : -1;
          }
          delay(300).then(() => setInstantSearchUiState({ query: state.query }));
        }

      skipInstantSearchUiStateUpdate = false;
    }, navigator: {
      navigate({ itemUrl }) {
        // Only allow navigation on Enter - disable arrow key navigation for suggestions
      },
      navigateNewTab({ itemUrl }) {
        // Handle new tab navigation if needed
      },
      navigateNewWindow({ itemUrl }) {
        // Handle new window navigation if needed
      }
    },  getSources({ query }) {
      // Only provide query suggestions after minimum threshold of 3 chars
      if (query.length < 3) {
        // Proactively clear any existing rendered suggestions panel content (Async lifecycle safe)
        const panel = document.querySelector('#recentsearchPanel');
        if (panel) {
          panel.style.display = 'none';
        }
        return [];
      }
      const panel = document.querySelector('#recentsearchPanel');
      if (panel) panel.style.display = 'block';
      // Initialize suggestions cache if needed
      if (typeof window.__lastSuggestionItems === 'undefined') {
        window.__lastSuggestionItems = [];
      }
      return [
        {
          sourceId: 'querySuggestions',
          getItemInputValue: ({ item }) => item.query,
          getItems() {
            return getAlgoliaResults({
              searchClient,
              queries: [
                {
                  indexName: 'Production_query_suggestions',
                  query,
                  params: {
                    hitsPerPage: 5,
                    filters: generateQuerySuggestionFilters(type, product),
                  },
                },
              ],
            });
          },
          transformItems(items) {
            if (items && items.length > 0) {
              return items;
            }
            const panelEl = document.querySelector('#recentsearchPanel');
            if (panelEl) panelEl.style.display = 'none';
            return [];
          },
          templates: {
              item({ item, components, html }) {
                // Get the current query from the autocomplete state
                const currentQuery = document.querySelector('.aa-Input')?.value || '';
                
                // Split the query and create highlighted parts
                if (!currentQuery || currentQuery.length === 0) {
                  return html`<div class="aa-ItemLink">
                    <div class="aa-Hit-container">
                      <span class="query-suggestion-text">${item.query}</span>
                    </div>
                  </div>`;
                }
                
                // Create highlighted version using html template
                const regex = new RegExp(`(${currentQuery})`, 'gi');
                const parts = item.query.split(regex);
                
                return html`<div class="aa-ItemLink">
                  <div class="aa-Hit-container">
                    <span class="query-suggestion-text">
                      ${parts.map(part => 
                        regex.test(part) 
                          ? html`<mark>${part}</mark>`
                          : part
                      )}
                    </span>
                  </div>
                </div>`;
              },
            },
          
        },
      ];
      }, 
  })

  // Enable vertical mouse wheel to scroll horizontal query suggestions
  setTimeout(() => {
    const horizPanel = document.querySelector('#recentsearchPanel .aa-List');
    if (horizPanel && !horizPanel._wheelBound) {
      horizPanel.addEventListener('wheel', (e) => {
        // Only hijack pure vertical scroll attempts (no shift key which already scrolls horizontally in some OS)
        if (Math.abs(e.deltaY) > Math.abs(e.deltaX)) {
          horizPanel.scrollLeft += e.deltaY;
          e.preventDefault();
        }
      }, { passive: false });
      horizPanel._wheelBound = true;
    }
  }, 300);

    }
let timeoutId;

function delay(t, v) {
  return new Promise(function(resolve) {
    clearTimeout(timeoutId);
    timeoutId = setTimeout(resolve.bind(null, v), t);
  });
}


 });

 //extract type and product from filter
 //for type : "Documentation page" AND product :"CEETRON Envision for Web"  returns type="Documentation page" and product="CEETRON Envision for Web"
//for type:"Documentation page" AND product:"CEETRON Envision for Web" returns type="Documentation page" and product="CEETRON Envision for Web"
//for (type:"Documentation page") AND (product:"CEETRON Envision for Web") returns type="Documentation page" and product="CEETRON Envision for Web"
//for Not product:"Dummy" returns type="" and product=""

function extractTypeAndProduct(filter) {
  let type = ''
  let product = ''
  let typeRegex = /type\s*:\s*\"(.*?)\"/g
  let productRegex = /product\s*:\s*\"(.*?)\"/g
  let typeMatch = typeRegex.exec(filter)
  let productMatch = productRegex.exec(filter)
  if (typeMatch) type = typeMatch[1]
  if (productMatch) product = productMatch[1]
  return { type, product }
}

//generate query suggestion filters given a type and product
//for type != "" and product != "Dummy" and product != "" returns ' Production.facets.exact_matches.type.value : ${type} and Production.facets.exact_matches.product.value: ${product} '
//otherwise return ''

function generateQuerySuggestionFilters(type, product) {
  if (type != "" && product != "Dummy" && product != "") {
    return ` Production.facets.exact_matches.type.value : "${type}" AND Production.facets.exact_matches.product.value: "${product}" `
  }
  return ''
}

// Function to substitute product names for display
function substituteProductName(productName) {
  const substitutions = {
    'HOOPS Communicator': 'HOOPS Visualize Web',
    'HOOPS Visualize HPS': 'HOOPS Visualize Desktop',
    'CEETRON Solve/Access/Mesh': 'HOOPS Solve/Access/Mesh',
    'CEETRON Envision for Web': 'HOOPS Envision for Web',
    'CEETRON Envision for Desktop': 'HOOPS Envision for Desktop'
  };
  
  return substitutions[productName] || productName;
}

