'use client'

import { HoopsButton, HoopsIcon, HoopsIconButton } from '@/@hoops/ui-kit-react/lib';
import { WebViewer, SelectionMode } from '@/@hoops/web-viewer';
import { HoopsModelTreeElement, ModelTreeNodeClickEvent } from '@/@hoops/web-viewer-components';
import { HoopsModelTree, HoopsModelTreeButton, HoopsWebviewerContextManager, WebViewerComponent } from '@hoops/web-viewer-components-react';
import { useRef, useState } from 'react';


export default function Viewer() {
    const hwvRef = useRef<WebViewer | null>(null);
    const modelTreeRef = useRef<HoopsModelTreeElement | null>(null);
    const [modelTreeVisible, setModelTreeVisible] = useState<boolean>(false);

    let modelTreeDisplay = "none";
    if (modelTreeVisible) modelTreeDisplay = "block";

    function modelReady(event: CustomEvent<{hwv: WebViewer}>) {
        const { hwv } = event.detail;
        hwvRef.current = hwv;
        if (modelTreeRef.current) {
            modelTreeRef.current.model = hwv.model;
        }

        hwvRef.current.setCallbacks({
            selectionArray: ()=> {
                modelTreeRef.current!.selected = hwvRef.current!.selectionManager.getResults().map((current)=> {
                    return current.getNodeId();
                });
            },
            visibilityChanged: (shownBodyIds: number[], hiddenBodyIds: number[])=> {
                shownBodyIds.forEach((nodeId)=>{
                    modelTreeRef.current?.updateNodeData(nodeId, {visible: true});
                });
                hiddenBodyIds.forEach((nodeId)=>{
                    modelTreeRef.current?.updateNodeData(nodeId, {visibility: false});
                })
            }
        });

    }

    function toggleTree() {
        if (modelTreeVisible) {
            setModelTreeVisible(false);
        }
        else {
            setModelTreeVisible(true);
        }
    }

    function handleNodeClick(event: CustomEvent<{nodeId: number}>) {
        event.stopPropagation();
        hwvRef.current?.selectionManager.clear(false);
        hwvRef.current?.selectionManager.selectNode(event.detail.nodeId, SelectionMode.Add);
    }

    function handleNodeVisibilityChange(event: CustomEvent<{nodeId: number, visibility: boolean}>) {
        event.stopPropagation();
        hwvRef.current?.model.setNodesVisibility([event.detail.nodeId], event.detail.visibility);
        modelTreeRef.current?.updateNodeData(event.detail.nodeId, {
            visible: event.detail.visibility
        });
    }

    return (
        <>
            <WebViewerComponent
                id='hwv'
                endpointUri='./microengine.scs'
                enginePath='./'
                hwvModelStructureReady={modelReady}
            />
            <div id="hwvHomeButton" style={{position: "absolute", top: "10px", right: "10px"}} onClick={()=>hwvRef.current?.reset()} >
                <HoopsIconButton>
                    <HoopsIcon icon="home"></HoopsIcon>
                </HoopsIconButton>
            </div>
            
         
            <HoopsModelTree id="hwvModelTree" style={{display: modelTreeDisplay}} ref={modelTreeRef} modelTreeNodeClick={handleNodeClick} modelTreeNodeVisibilityChange={handleNodeVisibilityChange}></HoopsModelTree>
          
           
            <div id="modelTreeDiv" style={{position: "absolute", top: "10px", left: "10px", zIndex: 2}} onClick={toggleTree}>
                <HoopsModelTreeButton id="hwvModelTreeButton"></HoopsModelTreeButton>
            </div>
            
        </>

     )
 }